/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class GetFileInfoBulkIT
extends ConfigurableMacBase {
    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.useMiniDFS(true);
        cfg.setProperty(Property.GC_FILE_ARCHIVE, "false");
    }

    long getOpts() throws Exception {
        String uri = this.getCluster().getMiniDfs().getHttpUri(0);
        URL url = new URL(uri + "/jmx");
        log.debug("Fetching web page " + url);
        String jsonString = FunctionalTestUtils.readAll(url.openStream());
        Gson gson = new Gson();
        Map jsonObject = (Map)gson.fromJson(jsonString, Object.class);
        List beans = (List)jsonObject.get("beans");
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").toString().equals("Hadoop:service=NameNode,name=NameNodeActivity")) continue;
            return (long)Double.parseDouble(map.get("FileInfoOps").toString());
        }
        return 0L;
    }

    @Test
    public void test() throws Exception {
        final Connector c = this.getConnector();
        this.getCluster().getClusterControl().kill(ServerType.GARBAGE_COLLECTOR, "localhost");
        final String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "2000");
        c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "2000");
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 15; ++i) {
            splits.add(new Text(Integer.toHexString(i)));
        }
        c.tableOperations().addSplits(tableName, splits);
        MasterMonitorInfo stats = this.getCluster().getMasterMonitorInfo();
        Assert.assertEquals((long)1L, (long)stats.tServerInfo.size());
        log.info("Creating lots of bulk import files");
        final FileSystem fs = this.getCluster().getFileSystem();
        Path basePath = this.getCluster().getTemporaryPath();
        CachedConfiguration.setInstance((Configuration)fs.getConf());
        final Path base = new Path(basePath, "testBulkLoad" + tableName);
        fs.delete(base, true);
        fs.mkdirs(base);
        ExecutorService es = Executors.newFixedThreadPool(5);
        ArrayList<Future<Pair<String, String>>> futures = new ArrayList<Future<Pair<String, String>>>();
        int i = 0;
        while (i < 10) {
            final int which = i++;
            futures.add(es.submit(new Callable<Pair<String, String>>(){

                @Override
                public Pair<String, String> call() throws Exception {
                    Path bulkFailures = new Path(base, "failures" + which);
                    Path files = new Path(base, "files" + which);
                    fs.mkdirs(bulkFailures);
                    fs.mkdirs(files);
                    for (int i = 0; i < 100; ++i) {
                        FileSKVWriter writer = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(files.toString() + "/bulk_" + i + "." + "rf", fs, fs.getConf()).withTableConfiguration((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration())).build();
                        writer.startDefaultLocalityGroup();
                        for (int j = 256; j < 4095; j += 3) {
                            writer.append(new Key((CharSequence)Integer.toHexString(j)), new Value(new byte[0]));
                        }
                        writer.close();
                    }
                    return new Pair((Object)files.toString(), (Object)bulkFailures.toString());
                }
            }));
        }
        ArrayList<Pair> dirs = new ArrayList<Pair>();
        for (Future future : futures) {
            dirs.add((Pair)future.get());
        }
        log.info("Importing");
        long startOps = this.getOpts();
        long now = System.currentTimeMillis();
        ArrayList<Future<Object>> errs = new ArrayList<Future<Object>>();
        for (Pair pair : dirs) {
            final String dir = (String)pair.getFirst();
            final String err = (String)pair.getSecond();
            errs.add(es.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    c.tableOperations().importDirectory(tableName, dir, err, false);
                    return null;
                }
            }));
        }
        for (Future future : errs) {
            future.get();
        }
        es.shutdown();
        es.awaitTermination(2L, TimeUnit.MINUTES);
        log.info(String.format("Completed in %.2f seconds", (double)(System.currentTimeMillis() - now) / 1000.0));
        UtilWaitThread.sleepUninterruptibly((long)30L, (TimeUnit)TimeUnit.SECONDS);
        long getFileInfoOpts = this.getOpts() - startOps;
        log.info("# opts: {}", (Object)getFileInfoOpts);
        Assert.assertTrue((String)"unexpected number of getFileOps", (getFileInfoOpts < 2100L && getFileInfoOpts > 1000L ? 1 : 0) != 0);
    }
}

