/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.impl.CompactionStrategyConfigUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class UserCompactionConfig
implements Writable {
    byte[] startRow;
    byte[] endRow;
    List<IteratorSetting> iterators;
    private CompactionStrategyConfig compactionStrategy;

    public UserCompactionConfig(byte[] startRow, byte[] endRow, List<IteratorSetting> iterators, CompactionStrategyConfig csc) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.iterators = iterators;
        this.compactionStrategy = csc;
    }

    public UserCompactionConfig() {
        this.startRow = null;
        this.endRow = null;
        this.iterators = Collections.emptyList();
        this.compactionStrategy = CompactionStrategyConfigUtil.DEFAULT_STRATEGY;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.startRow != null);
        if (this.startRow != null) {
            out.writeInt(this.startRow.length);
            out.write(this.startRow);
        }
        out.writeBoolean(this.endRow != null);
        if (this.endRow != null) {
            out.writeInt(this.endRow.length);
            out.write(this.endRow);
        }
        out.writeInt(this.iterators.size());
        for (IteratorSetting is : this.iterators) {
            is.write(out);
        }
        CompactionStrategyConfigUtil.encode((DataOutput)out, (CompactionStrategyConfig)this.compactionStrategy);
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.startRow = new byte[in.readInt()];
            in.readFully(this.startRow);
        } else {
            this.startRow = null;
        }
        if (in.readBoolean()) {
            this.endRow = new byte[in.readInt()];
            in.readFully(this.endRow);
        } else {
            this.endRow = null;
        }
        int num = in.readInt();
        this.iterators = new ArrayList<IteratorSetting>(num);
        for (int i = 0; i < num; ++i) {
            this.iterators.add(new IteratorSetting(in));
        }
        this.compactionStrategy = CompactionStrategyConfigUtil.decode((DataInput)in);
    }

    public Text getEndRow() {
        if (this.endRow == null) {
            return null;
        }
        return new Text(this.endRow);
    }

    public Text getStartRow() {
        if (this.startRow == null) {
            return null;
        }
        return new Text(this.startRow);
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public CompactionStrategyConfig getCompactionStrategy() {
        return this.compactionStrategy;
    }
}

