/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.impl.CompactionStrategyConfigUtil;
import org.apache.hadoop.io.Text;

public class CompactionConfig {
    private Text start = null;
    private Text end = null;
    private boolean flush = true;
    private boolean wait = true;
    private List<IteratorSetting> iterators = Collections.emptyList();
    private CompactionStrategyConfig compactionStrategy = CompactionStrategyConfigUtil.DEFAULT_STRATEGY;

    public CompactionConfig setStartRow(Text start) {
        this.start = start;
        return this;
    }

    public Text getStartRow() {
        return this.start;
    }

    public CompactionConfig setEndRow(Text end) {
        this.end = end;
        return this;
    }

    public Text getEndRow() {
        return this.end;
    }

    public CompactionConfig setFlush(boolean flush2) {
        this.flush = flush2;
        return this;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public CompactionConfig setWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public boolean getWait() {
        return this.wait;
    }

    public CompactionConfig setIterators(List<IteratorSetting> iterators) {
        this.iterators = new ArrayList<IteratorSetting>(iterators);
        return this;
    }

    public List<IteratorSetting> getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public CompactionConfig setCompactionStrategy(CompactionStrategyConfig csConfig) {
        Objects.requireNonNull(csConfig);
        this.compactionStrategy = csConfig;
        return this;
    }

    public CompactionStrategyConfig getCompactionStrategy() {
        return this.compactionStrategy;
    }
}

