/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.io;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String description;
    private HashSet<String> extensions;
    private String defaultExtension;

    public ExtensionFileFilter(String string, String string2) {
        this.description = string;
        this.extensions = new HashSet();
        this.extensions.add(string2.toLowerCase());
        this.defaultExtension = string2;
    }

    public ExtensionFileFilter(String string, String[] stringArray) {
        this.description = string;
        this.extensions = new HashSet();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        this.extensions.addAll(Arrays.asList(stringArray2));
        this.defaultExtension = stringArray[0];
    }

    public Set<String> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1 || n == string.length() - 1) {
            return this.extensions.contains("");
        }
        return this.extensions.contains(string.substring(n + 1).toLowerCase());
    }

    public File makeAcceptable(File file) {
        if (this.accept(file)) {
            return file;
        }
        return new File(file.getPath() + '.' + this.defaultExtension);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

