# - GPSTk: GNSS data processing library and applications by SGL @ ARL:UT.
#The primary goals of the GPSTk project are to:
# * provide applications for use by the GNSS and satellite navigation community.
# * provide a core library to facilitate the development of GNSS applications.
#
#==============================================================================
# The source code provided by the GPSTk is distributed under the GNU LGPL, Version 3.
#
# * This license gives all users the right to use and redistribute the code.
# * Users of the GPSTk are not required to open their source, according to the LGPL.
# * This makes the GPSTk a practical choice for commercial projects.
# * Full text copies of the GPL (COPYING.txt) and the LGPL (COPYING.LESSER.txt) are included with the GPSTk distribution package. 
#
# For more information about the GPL or LGP, please refer to the following:
#
# * http://www.gnu.org/copyleft/lesser.html
# * http://www.gnu.org/licenses/gpl-howto.html
#==============================================================================

set( GPSTK_FOUND TRUE )


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was GPSTKConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set( GPSTK_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/gpstk" )
set( GPSTK_BINDIR "${PACKAGE_PREFIX_DIR}/bin" )
set( GPSTK_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib" )
set( GPSTK_RUNTIME_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib" )
set( GPSTK_ROOT_DIR "${PACKAGE_PREFIX_DIR}" )
set( GPSTK_PYTHON_DIR "" )

include("${PACKAGE_PREFIX_DIR}/share/cmake/GPSTK/GPSTKTargets.cmake")

message(STATUS "GPSTk found at ${GPSTK_ROOT_DIR}")
