/*

Copyright (c) 2014, 2017-2020, Arvid Norberg
Copyright (c) 2016, Alden Torres
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the distribution.
    * Neither the name of the author nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

#ifndef TORRENT_CHOKER_HPP_INCLUDED
#define TORRENT_CHOKER_HPP_INCLUDED

#include "libtorrent/config.hpp"
#include "libtorrent/time.hpp" // for time_duration
#include <vector>

namespace libtorrent {

namespace aux {
	struct session_settings;
}
	struct peer_connection;

	// sorts the vector of peers in-place. When returning, the top unchoke slots
	// elements are the peers we should unchoke. This is similar to a partial
	// sort. Only the unchoke slots first elements are sorted.
	// the return value are the number of peers that should be unchoked. This
	// is also the number of elements that are valid at the beginning of the
	// peer list. Peers beyond this initial range are not sorted.
	TORRENT_EXTRA_EXPORT int unchoke_sort(std::vector<peer_connection*>& peers
		, time_duration unchoke_interval
		, aux::session_settings const& sett);

}

#endif // TORRENT_CHOKER_INCLUDED
