# SPDX-FileCopyrightText: 2014 Christophe Giboudeaux <cgiboudeaux@gmx.com>
# SPDX-License-Identifier: BSD-3-Clause


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KPimTextEditConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
include(CMakeFindDependencyMacro)
find_dependency(KF5TextWidgets "5.105.0")
if (TRUE)
	find_dependency(KF5TextEditTextToSpeech "1.0.0")
endif()

if (TRUE)
    message(WARNING "\n"
                    "************* DEPRECATION WARNING *************\n"
		    "Using find_package(KF5PimTextEdit) and KF5::PimTextEdit targets is deprecated. "
		    "Please use find_package(KPim5PimTextEdit) and KPim5::PimTextEdit instead. This backwards "
                    "compatibility will be removed in the next major version.\n"
                    "***********************************************\n")
endif()


include("${CMAKE_CURRENT_LIST_DIR}/KPim5TextEditTargets.cmake")

