/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.CommandListener;
import jde.debugger.DebuggeeSIO;
import jde.debugger.EventHandler;
import jde.debugger.EventSetListener;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.SessionManager;
import jde.debugger.VMUtil;
import jde.debugger.command.CommandHandler;
import jde.debugger.command.ProcessCommandHandler;
import jde.debugger.gui.GUI;
import jde.debugger.spec.EventRequestSpecList;

public class Debugger
implements Protocol {
    private ProcessCommandHandler m_handler;
    private VirtualMachine m_vm;
    private boolean m_vmAlive;
    private EventRequestSpecList m_eventRequestSpecList;
    private Integer m_procID;
    private DebuggeeSIO m_sio;
    private EventHandler m_eventHandler;
    private ObjectStore m_objectStore;
    private boolean m_useGUI;
    private GUI m_gui;
    protected Map m_identifiableEventRequests;

    public Debugger(Integer procID, boolean useGUI) {
        JDE.debug(4, "creating debugger with id: " + procID);
        this.m_procID = procID;
        this.m_identifiableEventRequests = new HashMap();
        this.m_handler = new ProcessCommandHandler(this);
        this.m_eventRequestSpecList = new EventRequestSpecList(this);
        this.m_sio = new DebuggeeSIO(this);
        this.m_eventHandler = new EventHandler(this);
        this.m_objectStore = new ObjectStore(this);
        this.m_vmAlive = false;
        this.m_useGUI = useGUI;
        this.m_gui = this.m_useGUI ? new GUI(this) : null;
    }

    public void start() throws JDEException {
        JDE.debug(4, "starting debugger: " + this.m_procID);
        if (!this.m_vmAlive) {
            throw new JDEException("INTERNAL ERROR: attempted to start debugger " + this.m_procID + " without a VM");
        }
        this.m_handler.start();
        this.m_eventHandler.start();
        ClassPrepareRequest cprequest = this.m_vm.eventRequestManager().createClassPrepareRequest();
        cprequest.putProperty("default", "default");
        cprequest.setSuspendPolicy(2);
        cprequest.addClassExclusionFilter("java.*");
        cprequest.addClassExclusionFilter("javax.*");
        cprequest.addClassExclusionFilter("sun.*");
        cprequest.enable();
    }

    public void stopExecution() {
        VMUtil.shutdown(this.m_vm);
        this.m_vmAlive = false;
    }

    public void shutdown() throws JDEException {
        JDE.debug(4, "debugger " + this.m_procID + " shutting down");
        if (this.m_vmAlive) {
            VMUtil.shutdown(this.m_vm);
            this.m_vmAlive = false;
        }
        if (this.m_handler != null) {
            this.m_handler.requestStop();
        }
        if (this.m_eventHandler != null) {
            this.m_eventHandler.shutdown();
        }
        if (this.m_sio != null) {
            this.m_sio.shutdown();
        }
        if (null != this.m_gui) {
            this.m_gui.shutdown();
        }
        this.m_handler = null;
        this.m_eventHandler = null;
        this.m_vm = null;
        this.m_sio = null;
        this.m_gui = null;
        SessionManager.deregisterDebugger(this);
    }

    public void launchVM(Integer cmdID, List args) throws JDEException {
        String arg;
        String connectSpec = "com.sun.jdi.CommandLineLaunch";
        LaunchingConnector connector = (LaunchingConnector)VMUtil.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
        Connector.Argument mainArg = argumentMap.get("main");
        String commandLine = "";
        String quote = argumentMap.get("quote").value();
        if (args.size() == 0) {
            throw new JDEException("Insufficient arguments");
        }
        String executable = "java";
        while (args.size() > 0 && args.get(0).toString().startsWith("-")) {
            String origArg = args.remove(0).toString();
            arg = origArg.toLowerCase();
            if (arg.equals("-vmexec")) {
                if (args.size() == 0) {
                    throw new JDEException("Missing argument to 'use_executable'");
                }
                executable = args.remove(0).toString();
                Connector.Argument vmexecArg = argumentMap.get("vmexec");
                vmexecArg.setValue(executable);
                continue;
            }
            if (arg.equals("-home")) {
                if (args.size() == 0) {
                    throw new JDEException("Missing argument to 'home'");
                }
                String home = args.remove(0).toString();
                Connector.Argument homeArg = argumentMap.get("home");
                homeArg.setValue(home);
                continue;
            }
            args.add(0, origArg);
            break;
        }
        if (args.size() == 0) {
            throw new JDEException("Missing arguments: no class specified?");
        }
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            arg = (String)iterator.next();
            if (arg.equalsIgnoreCase("-classic")) {
                Connector.Argument optionsArg = argumentMap.get("options");
                String options = optionsArg.value();
                options = "-classic " + options;
                optionsArg.setValue(options);
                JDE.signal(this.m_procID, "message", "VM options: '" + options + "'", true);
                continue;
            }
            commandLine = commandLine + quote + arg + quote + " ";
        }
        mainArg.setValue(commandLine);
        this.m_vm = null;
        try {
            this.m_vm = connector.launch(argumentMap);
            JDE.signal(this.m_procID, "message", "Launched VM " + this.m_vm.description(), true);
            this.m_vmAlive = true;
            this.m_sio.initConnect(cmdID);
        }
        catch (IOException ex) {
            JDE.debug(8, "Exception launching VM: " + ex.toString());
            throw new JDEException("Unable to launch: " + ex.toString().replace('\\', '/'));
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Invalid or inconsistent connector arguments for connector '" + connector + "'");
        }
        catch (VMStartException ex) {
            throw new JDEException(ex.getMessage().toString().replace('\\', '/'));
        }
    }

    public void attachVMShmem(List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing name");
        }
        String connectSpec = null;
        connectSpec = "com.sun.jdi.SharedMemoryAttach";
        AttachingConnector connector = (AttachingConnector)VMUtil.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            Connector.Argument nameArg = argumentMap.get("name");
            nameArg.setValue(args.remove(0).toString());
            this.m_vm = connector.attach(argumentMap);
            this.m_vmAlive = true;
            JDE.signal(this.m_procID, "message", "Attached VM (shmem) " + this.m_vm.description(), true);
        }
        catch (IOException ex) {
            JDE.debug(8, ex.toString());
            throw new JDEException("Error attempting to attach to process via shared memory.");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    public void attachVMSocket(List args) throws JDEException {
        if (args.size() < 1) {
            throw new JDEException("Missing arguments: specify at least the port");
        }
        String connectSpec = null;
        connectSpec = "com.sun.jdi.SocketAttach";
        AttachingConnector connector = (AttachingConnector)VMUtil.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        try {
            Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
            while (args.size() > 0 && args.get(0).toString().startsWith("-")) {
                String arg = args.remove(0).toString().toLowerCase();
                if (arg.equals("-host")) {
                    if (args.size() == 0) {
                        throw new JDEException("Missing argument to 'host'");
                    }
                    String host = args.remove(0).toString();
                    Connector.Argument hostArg = argumentMap.get("hostname");
                    hostArg.setValue(host);
                    continue;
                }
                if (arg.equals("-port")) {
                    if (args.size() == 0) {
                        throw new JDEException("Missing argument to 'port'");
                    }
                    String port = args.remove(0).toString();
                    Connector.Argument portArg = argumentMap.get("port");
                    portArg.setValue(port);
                    continue;
                }
                args.add(0, arg);
                break;
            }
            this.m_vm = connector.attach(argumentMap);
            this.m_vmAlive = true;
            JDE.signal(this.m_procID, "message", "Attached VM (socket) " + this.m_vm.description(), true);
        }
        catch (IOException ex) {
            JDE.debug(8, ex.toString());
            throw new JDEException("I/O error occurred while attempting to attach process.");
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Illegal connector arguments for connector '" + connector);
        }
    }

    public void listenShmem(final String address) throws JDEException {
        String connectSpec = "com.sun.jdi.SharedMemoryListen";
        final ListeningConnector connector = (ListeningConnector)VMUtil.getConnector(connectSpec);
        final Debugger thisAsLocal = this;
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Thread thread = new Thread("Listen on shared memory channel."){

            public void run() {
                try {
                    Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
                    Connector.Argument nameArg = argumentMap.get("name");
                    nameArg.setValue(address);
                    connector.startListening(argumentMap);
                    Debugger.this.m_vm = connector.accept(argumentMap);
                    connector.stopListening(argumentMap);
                    JDE.signal(Debugger.this.m_procID, "message", "Attached VM (shmem) " + Debugger.this.m_vm.description(), true);
                    Debugger.this.m_vmAlive = true;
                    thisAsLocal.start();
                }
                catch (IOException ex) {
                    JDE.debug(8, ex.toString());
                    JDE.signal(Debugger.this.m_procID, "message", "I/O error occurred while listening at shared memory address:" + address, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {}
                }
                catch (IllegalConnectorArgumentsException ex) {
                    JDE.debug(8, ex.toString());
                    JDE.signal(Debugger.this.m_procID, "message", "Illegal argument error occurred while listening at shared memory address: " + address, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {}
                }
                catch (JDEException ex) {
                    JDE.debug(8, ex.toString());
                    JDE.signal(Debugger.this.m_procID, "message", "Error starting up debugger: " + ex, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {
                        // empty catch block
                    }
                }
            }
        };
        JDE.signal(this.m_procID, "message", "Listening at shared memory address: " + address, true);
        thread.start();
    }

    public void listenSocket(final String address) throws JDEException {
        String connectSpec = "com.sun.jdi.SocketListen";
        final ListeningConnector connector = (ListeningConnector)VMUtil.getConnector(connectSpec);
        final Debugger thisAsLocal = this;
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Thread thread = new Thread("Listen on socket."){

            public void run() {
                try {
                    Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
                    Connector.Argument portArg = argumentMap.get("port");
                    portArg.setValue(address);
                    connector.startListening(argumentMap);
                    Debugger.this.m_vm = connector.accept(argumentMap);
                    connector.stopListening(argumentMap);
                    JDE.signal(Debugger.this.m_procID, "message", "Attached VM (socket) " + Debugger.this.m_vm.description(), true);
                    Debugger.this.m_vmAlive = true;
                    thisAsLocal.start();
                }
                catch (IOException ex) {
                    JDE.debug(8, ex.toString());
                    JDE.signal(Debugger.this.m_procID, "message", "Error occurred when listening on socket: " + ex, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {}
                }
                catch (IllegalConnectorArgumentsException ex) {
                    JDE.signal(Debugger.this.m_procID, "message", "Illegal connector arguments for connector '" + connector + " " + ex, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {}
                }
                catch (JDEException ex) {
                    JDE.signal(Debugger.this.m_procID, "message", "Error starting up debugger: " + ex, true);
                    try {
                        SessionManager.deregisterDebugger(thisAsLocal);
                    }
                    catch (JDEException e) {
                        // empty catch block
                    }
                }
            }
        };
        JDE.signal(this.m_procID, "message", "Listening at socket address: " + address, true);
        thread.start();
    }

    public EventRequestSpecList getEventRequestSpecList() {
        return this.m_eventRequestSpecList;
    }

    public CommandHandler getCommandHandler() {
        return this.m_handler;
    }

    public Integer getProcID() {
        return this.m_procID;
    }

    public ObjectStore getStore() {
        return this.m_objectStore;
    }

    public void signalCommandResult(Integer cmdID, String message, boolean success) {
        JDE.commandResult(cmdID, message, success, false);
    }

    public void signalCommandResult(Integer cmdID, String message, boolean success, boolean quote) {
        JDE.commandResult(cmdID, message, success, quote);
    }

    public VirtualMachine getVM() {
        return this.m_vm;
    }

    public GUI getGUI() {
        return this.m_gui;
    }

    public boolean isValid() {
        return this.m_handler != null;
    }

    public ThreadReference getThreadReference(String name) {
        List<ThreadReference> list = this.m_vm.allThreads();
        Iterator<ThreadReference> it = list.iterator();
        while (it.hasNext()) {
            ThreadReference thread = it.next();
            if (!thread.name().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public Long addIdentifiableRequest(EventRequest e) {
        Long id = SessionManager.generateObjectID();
        Map map = this.m_identifiableEventRequests;
        synchronized (map) {
            this.m_identifiableEventRequests.put(id, e);
        }
        e.enable();
        return id;
    }

    public void deleteIdentifiableRequest(Long id) throws JDEException {
        EventRequestManager erm = this.getVM().eventRequestManager();
        Map map = this.m_identifiableEventRequests;
        synchronized (map) {
            if (!this.m_identifiableEventRequests.containsKey(id)) {
                throw new JDEException("Invalid request ID");
            }
            Object e = this.m_identifiableEventRequests.remove(id);
            if (e == null) {
                throw new JDEException("No such event request");
            }
            if (!(e instanceof EventRequest)) {
                throw new JDEException("INTERNAL ERROR: Not an event request : " + e.toString());
            }
            ((EventRequest)e).disable();
            erm.deleteEventRequest((EventRequest)e);
        }
    }

    public void addEventSetListener(EventSetListener listener) {
        this.m_eventHandler.addEventSetListener(listener);
    }

    public void removeEventSetListener(EventSetListener listener) {
        this.m_eventHandler.removeEventSetListener(listener);
    }

    public void addCommandListener(CommandListener listener) {
        this.m_handler.addCommandListener(listener);
    }

    public void removeCommandListener(CommandListener listener) {
        this.m_handler.removeCommandListener(listener);
    }
}

