/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jde.debugger.JDEException;
import jde.debugger.gui.LVTreeNode;

class PrimitiveTreeNode
extends LVTreeNode {
    private Value m_value;

    protected PrimitiveTreeNode(String name, String typeName, Value val, DefaultTreeModel model) throws JDEException {
        super(name, typeName, val, model);
        if (!(this.m_type instanceof PrimitiveType)) {
            throw new JDEException("PrimitiveTreeNode received non-primitive Type " + this.m_type.name());
        }
        if (!(val instanceof PrimitiveValue)) {
            throw new JDEException("PrimitiveTreeNode received non-primitive value " + val.type().name());
        }
        this.m_value = val;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int index) {
        throw new IllegalArgumentException("Attempt to create a child of a Primitive");
    }

    public int getIndex(TreeNode node) {
        return -1;
    }

    String getValue() {
        return this.m_value.toString();
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return new Vector().elements();
    }

    void valueChanged(Value val) {
        this.m_value = val;
    }
}

