# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class Query(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'extern': 'File',
        'query': 'str',
        'type': 'str',
        'params': 'dict(str, object)',
        'dialect': 'Dialect',
        'now': 'datetime'
    }

    attribute_map = {
        'extern': 'extern',
        'query': 'query',
        'type': 'type',
        'params': 'params',
        'dialect': 'dialect',
        'now': 'now'
    }

    def __init__(self, extern=None, query=None, type=None, params=None, dialect=None, now=None):  # noqa: E501,D401,D403
        """Query - a model defined in OpenAPI."""  # noqa: E501
        self._extern = None
        self._query = None
        self._type = None
        self._params = None
        self._dialect = None
        self._now = None
        self.discriminator = None

        if extern is not None:
            self.extern = extern
        self.query = query
        if type is not None:
            self.type = type
        if params is not None:
            self.params = params
        if dialect is not None:
            self.dialect = dialect
        if now is not None:
            self.now = now

    @property
    def extern(self):
        """Get the extern of this Query.

        :return: The extern of this Query.
        :rtype: File
        """  # noqa: E501
        return self._extern

    @extern.setter
    def extern(self, extern):
        """Set the extern of this Query.

        :param extern: The extern of this Query.
        :type: File
        """  # noqa: E501
        self._extern = extern

    @property
    def query(self):
        """Get the query of this Query.

        Query script to execute.

        :return: The query of this Query.
        :rtype: str
        """  # noqa: E501
        return self._query

    @query.setter
    def query(self, query):
        """Set the query of this Query.

        Query script to execute.

        :param query: The query of this Query.
        :type: str
        """  # noqa: E501
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")  # noqa: E501
        self._query = query

    @property
    def type(self):
        """Get the type of this Query.

        The type of query. Must be "flux".

        :return: The type of this Query.
        :rtype: str
        """  # noqa: E501
        return self._type

    @type.setter
    def type(self, type):
        """Set the type of this Query.

        The type of query. Must be "flux".

        :param type: The type of this Query.
        :type: str
        """  # noqa: E501
        self._type = type

    @property
    def params(self):
        """Get the params of this Query.

        Enumeration of key/value pairs that respresent parameters to be injected into query (can only specify either this field or extern and not both)

        :return: The params of this Query.
        :rtype: dict(str, object)
        """  # noqa: E501
        return self._params

    @params.setter
    def params(self, params):
        """Set the params of this Query.

        Enumeration of key/value pairs that respresent parameters to be injected into query (can only specify either this field or extern and not both)

        :param params: The params of this Query.
        :type: dict(str, object)
        """  # noqa: E501
        self._params = params

    @property
    def dialect(self):
        """Get the dialect of this Query.

        :return: The dialect of this Query.
        :rtype: Dialect
        """  # noqa: E501
        return self._dialect

    @dialect.setter
    def dialect(self, dialect):
        """Set the dialect of this Query.

        :param dialect: The dialect of this Query.
        :type: Dialect
        """  # noqa: E501
        self._dialect = dialect

    @property
    def now(self):
        """Get the now of this Query.

        Specifies the time that should be reported as "now" in the query. Default is the server's now time.

        :return: The now of this Query.
        :rtype: datetime
        """  # noqa: E501
        return self._now

    @now.setter
    def now(self, now):
        """Set the now of this Query.

        Specifies the time that should be reported as "now" in the query. Default is the server's now time.

        :param now: The now of this Query.
        :type: datetime
        """  # noqa: E501
        self._now = now

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, Query):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
