'''OpenGL extension NV.path_rendering_shared_edge

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.path_rendering_shared_edge to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces a new path command modifier to the
	NV_path_rendering extension to indicate that a path command represents an
	edge (either straight or curved) that is shared with another path.
	
	When used in conjunction with NV_framebuffer_mixed_samples, a shared edge
	(or a whole path including shared edges) will use modified rasterization
	rules in order to ensure that groups of raster samples associated with a
	given coverage sample will all produce consistent coverage results, in
	order to avoid artifacts described further in the issues section at the
	end of this document.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/path_rendering_shared_edge.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.path_rendering_shared_edge import *
from OpenGL.raw.GLES2.NV.path_rendering_shared_edge import _EXTENSION_NAME

def glInitPathRenderingSharedEdgeNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION