create table groups (groupid integer primary key, gname text, gdisplay text, gapid text, flags integer, gmeta text);
create table posts (postid integer primary key, pgroupid integer, ppersonid integer, postxid text, postapid text, dt text, title text, lnk text, content text, postmeta text);
create table comments (commentid integer primary key, cpostid integer, cpersonid integer, parentid integer, cxid text, capid text, cdt text, subject text, ccontent text, cmeta text);
create table chats (chatid integer primary key, cgroupid integer, cpersonid integer, cxid text, capid text, cdt text, ccontent text);
create table persons (personid integer primary key, pname text, display text, papid text, personmeta text);


create table subs (subid integer primary key, userid integer, groupid integer, personid integer, postid integer);
create table shares (shareid integer primary key, personid integer, postid integer);
create table attachments (attachmentid integer primary key, postid integer, xid text, media text, description text);
create table files (fileid integer primary key, hash text, url text, media text, xid text);
create table pubkeys (pubkeyid integer primary key, url text, owner text, pubkey text, dt text);
create table seckeys (seckeyid integer primary key, owner text, seckey text);
create table follows (followid integer primary key, folxid text, who text, what text);
create table deliveries (deliveryid integer primary key, dt text, tries integer, rcpt text, data blob);
create table peers (peerid integer primary key, who text, what text, notes text);
create table reports (reportid integer primary key, who text, what text, were text, dt text, meta text);
create table tombstones (tombstoneid integer primary key, what text);
create table notifs (notifid integer primary key, userid integer, dt text, flags integer, msg text, url text);
create table filters (filterid integer primary key, userid integer, data text);

create index idxgroups_name on groups(gname);
create index idxgroups_apid on groups(gapid);
create index idxposts_groupid on posts(pgroupid);
create index idxposts_personid on posts(ppersonid);
create index idxposts_xid on posts(postxid);
create index idxposts_apid on posts(postapid);
create index idxcomments_postid on comments(cpostid);
create index idxcomments_xid on comments(cxid);
create index idxcomments_apid on comments(capid);
create index idxchats_groupid on chats(cgroupid);
create index idxchats_xid on chats(cxid);
create index idxchats_apid on chats(capid);
create index idxpersons_name on persons(pname);
create index idxpersons_apid on persons(papid);
create index idxsubs_userid on subs(userid);
create index idxsubs_groupid on subs(groupid) where groupid > 0;
create index idxsubs_personid on subs(personid) where personid > 0;
create index idxsubs_postid on subs(postid) where postid > 0;
create index idxshares_personid on shares(personid);
create index idxattachments_xid on attachments(xid);
create index idxattachments_postid on attachments(postid);
create index idxfiles_hash on files(hash);
create index idxfiles_url on files(url);
create index idxpubkeys_url on pubkeys(url);
create index idxseckeys_owner on seckeys(owner);
create index idxfollows_xid on follows(folxid);
create index idxfollows_who on follows(who);
create index idxfollows_what on follows(what);
create index idxdeliveries_rcpt on deliveries(rcpt);
create index idxnotifs_userid on notifs(userid);
create index idxtombstones_what on tombstones(what);

create table config (key text, value text);

create table users (userid integer primary key, username text, hash text, flags integer, email text, personid integer);
create table auth (authid integer primary key, userid integer, hash text, expiry text);
CREATE index idxusers_username on users(username);
CREATE index idxauth_userid on auth(userid);
CREATE index idxauth_hash on auth(hash);

