/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.stunclient.SimpleAddressDetector;

public class StunMappingCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunMappingCandidateHarvester.class.getName());
    private TransportAddress stunServerAddress;

    public StunMappingCandidateHarvester(TransportAddress localAddress, TransportAddress stunServerAddress) {
        this.face = localAddress;
        this.stunServerAddress = stunServerAddress;
    }

    public void discover() {
        try {
            SimpleAddressDetector sad = new SimpleAddressDetector(this.stunServerAddress);
            sad.start();
            IceUdpSocketWrapper localSocket = new IceUdpSocketWrapper(new DatagramSocket(this.face));
            this.mask = sad.getMappingFor(localSocket);
            SocketAddress boundAddr = ((IceSocketWrapper)localSocket).getLocalSocketAddress();
            if (boundAddr instanceof InetSocketAddress) {
                this.face = new TransportAddress((InetSocketAddress)boundAddr, this.face.getTransport());
            }
            if (this.mask != null) {
                logger.info("Discovered public address " + this.mask + " from STUN server " + this.stunServerAddress + " using local address " + this.face);
            }
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain addresses for the following reason: ", exc);
        }
    }
}

