/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderODataAtomParser
extends SpiderParser {
    private static final Pattern patternURL = Pattern.compile("href=\\\"([\\w();&'/,=\\-]*)\\\"");
    private static final Pattern patternBase = Pattern.compile("base=\"(http(s?)://[^\\x00-\\x1f\"'\\s<>#]+)\"");

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        this.getLogger().debug("Parsing an OData Atom resource.");
        String baseURL = message.getRequestHeader().getURI().toString();
        String bodyAsStr = message.getResponseBody().toString();
        Matcher matcher = patternBase.matcher(bodyAsStr);
        if (matcher.find()) {
            baseURL = matcher.group(1);
            baseURL = StringEscapeUtils.unescapeXml(baseURL);
        }
        boolean foundAtLeastOneResult = false;
        matcher = patternURL.matcher(bodyAsStr);
        while (matcher.find()) {
            String s = matcher.group(1);
            s = StringEscapeUtils.unescapeXml(s);
            this.processURL(message, depth, s, baseURL);
            foundAtLeastOneResult = true;
        }
        return foundAtLeastOneResult;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        return !wasAlreadyParsed && message.getResponseHeader().isXml();
    }
}

