/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.spider.filters.FetchFilter;

public class MaxChildrenFetchFilter
extends FetchFilter {
    private int maxChildren = -1;
    private Model model;

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uri) {
        this.getLogger().debug("Checking: " + uri);
        SiteNode parent = this.model.getSession().getSiteTree().findClosestParent(uri);
        if (parent != null && this.maxChildren > 0 && parent.getChildCount() > this.maxChildren) {
            return FetchFilter.FetchStatus.USER_RULES;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public void setModel(Model model) {
        this.model = model;
    }
}

