/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import org.parosproxy.paros.common.AbstractParam;

public class DatabaseParam
extends AbstractParam {
    public static final int NEW_SESSION_NOT_SPECIFIED = 0;
    public static final int NEW_SESSION_TIMESTAMPED = 1;
    public static final int NEW_SESSION_USER_SPECIFIED = 2;
    public static final int NEW_SESSION_TEMPORARY = 3;
    private static final String PARAM_BASE_KEY = "database";
    private static final String PARAM_COMPACT_DATABASE = "database.compact";
    private static final String PARAM_REQUEST_BODY_SIZE = "database.request.bodysize";
    private static final String PARAM_RESPONSE_BODY_SIZE = "database.response.bodysize";
    private static final String PARAM_NEW_SESSION_OPTION = "database.newsession";
    private static final String PARAM_NEW_SESSION_PROMPT = "database.newsessionprompt";
    private static final String PARAM_RECOVERY_LOG_ENABLED = "database.recoverylog";
    private static final boolean DEFAULT_COMPACT_DATABASE = false;
    private static final int DEFAULT_BODY_SIZE = 0x1000000;
    private static final int DEFAULT_NEW_SESSION_OPTION = 0;
    private static final boolean DEFAULT_NEW_SESSION_PROMPT = true;
    private static final boolean DEFAULT_RECOVERY_LOG_ENABLED = true;
    private boolean compactDatabase = false;
    private int requestbodysize = 0x1000000;
    private int responsebodysize = 0x1000000;
    private int newSessionOption = 0;
    private boolean newSessionPrompt = true;
    private boolean recoveryLogEnabled = true;

    @Override
    protected void parse() {
        this.compactDatabase = this.getBoolean(PARAM_COMPACT_DATABASE, false);
        this.requestbodysize = this.getInt(PARAM_REQUEST_BODY_SIZE, 0x1000000);
        this.responsebodysize = this.getInt(PARAM_RESPONSE_BODY_SIZE, 0x1000000);
        this.newSessionOption = this.getInt(PARAM_NEW_SESSION_OPTION, 0);
        this.newSessionPrompt = this.getBoolean(PARAM_NEW_SESSION_PROMPT, true);
        this.recoveryLogEnabled = this.getBoolean(PARAM_RECOVERY_LOG_ENABLED, true);
    }

    public boolean isCompactDatabase() {
        return this.compactDatabase;
    }

    public void setCompactDatabase(boolean compactDatabase) {
        this.compactDatabase = compactDatabase;
        this.getConfig().setProperty(PARAM_COMPACT_DATABASE, compactDatabase);
    }

    public int getRequestBodySize() {
        return this.requestbodysize;
    }

    public void setRequestBodySize(int requestbodysize) {
        this.requestbodysize = requestbodysize;
        this.getConfig().setProperty(PARAM_REQUEST_BODY_SIZE, requestbodysize);
    }

    public int getResponseBodySize() {
        return this.responsebodysize;
    }

    public void setResponseBodySize(int responsebodysize) {
        this.responsebodysize = responsebodysize;
        this.getConfig().setProperty(PARAM_RESPONSE_BODY_SIZE, responsebodysize);
    }

    public int getNewSessionOption() {
        return this.newSessionOption;
    }

    public void setNewSessionOption(int newSessionOption) {
        this.newSessionOption = newSessionOption;
        this.getConfig().setProperty(PARAM_NEW_SESSION_OPTION, newSessionOption);
    }

    public boolean isNewSessionPrompt() {
        return this.newSessionPrompt;
    }

    public void setNewSessionPrompt(boolean newSessionPrompt) {
        this.newSessionPrompt = newSessionPrompt;
        this.getConfig().setProperty(PARAM_NEW_SESSION_PROMPT, newSessionPrompt);
    }

    public boolean isRecoveryLogEnabled() {
        return this.recoveryLogEnabled;
    }

    public void setRecoveryLogEnabled(boolean enabled) {
        this.recoveryLogEnabled = enabled;
        this.getConfig().setProperty(PARAM_RECOVERY_LOG_ENABLED, this.recoveryLogEnabled);
    }
}

