/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.model.Position;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Request;

@Singleton
@ChannelHandler.Sharable
public class DefaultDataHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataHandler.class);
    private final Storage storage;

    @Inject
    public DefaultDataHandler(Storage storage) {
        this.storage = storage;
    }

    @Override
    protected Position handlePosition(Position position) {
        try {
            position.setId(this.storage.addObject(position, new Request(new Columns.Exclude("id"))));
        }
        catch (Exception error) {
            LOGGER.warn("Failed to store position", (Throwable)error);
        }
        return position;
    }
}

