/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.broadcast;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastMessage;
import org.traccar.broadcast.BroadcastService;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Permission;
import org.traccar.model.Position;

public abstract class BaseBroadcastService
implements BroadcastService {
    private final Set<BroadcastInterface> listeners = new HashSet<BroadcastInterface>();

    @Override
    public boolean singleInstance() {
        return true;
    }

    @Override
    public void registerListener(BroadcastInterface listener) {
        this.listeners.add(listener);
    }

    @Override
    public void updateDevice(boolean local, Device device) {
        BroadcastMessage message = new BroadcastMessage();
        message.setDevice(device);
        this.sendMessage(message);
    }

    @Override
    public void updatePosition(boolean local, Position position) {
        BroadcastMessage message = new BroadcastMessage();
        message.setPosition(position);
        this.sendMessage(message);
    }

    @Override
    public void updateEvent(boolean local, long userId, Event event) {
        BroadcastMessage message = new BroadcastMessage();
        message.setUserId(userId);
        message.setEvent(event);
        this.sendMessage(message);
    }

    @Override
    public void updateCommand(boolean local, long deviceId) {
        BroadcastMessage message = new BroadcastMessage();
        message.setCommandDeviceId(deviceId);
        this.sendMessage(message);
    }

    @Override
    public void invalidateObject(boolean local, Class<? extends BaseModel> clazz, long id) {
        BroadcastMessage message = new BroadcastMessage();
        message.setChanges(Map.of(Permission.getKey(clazz), id));
        this.sendMessage(message);
    }

    @Override
    public void invalidatePermission(boolean local, Class<? extends BaseModel> clazz1, long id1, Class<? extends BaseModel> clazz2, long id2) {
        BroadcastMessage message = new BroadcastMessage();
        message.setChanges(Map.of(Permission.getKey(clazz1), id1, Permission.getKey(clazz2), id2));
        this.sendMessage(message);
    }

    protected abstract void sendMessage(BroadcastMessage var1);

    protected void handleMessage(BroadcastMessage message) {
        Iterator<Map.Entry<String, Long>> iterator;
        if (message.getDevice() != null) {
            this.listeners.forEach(listener -> listener.updateDevice(false, message.getDevice()));
        } else if (message.getPosition() != null) {
            this.listeners.forEach(listener -> listener.updatePosition(false, message.getPosition()));
        } else if (message.getUserId() != null && message.getEvent() != null) {
            this.listeners.forEach(listener -> listener.updateEvent(false, message.getUserId(), message.getEvent()));
        } else if (message.getCommandDeviceId() != null) {
            this.listeners.forEach(listener -> listener.updateCommand(false, message.getCommandDeviceId()));
        } else if (message.getChanges() != null && (iterator = message.getChanges().entrySet().iterator()).hasNext()) {
            Map.Entry<String, Long> first = iterator.next();
            if (iterator.hasNext()) {
                Map.Entry<String, Long> second = iterator.next();
                this.listeners.forEach(listener -> listener.invalidatePermission(false, Permission.getKeyClass((String)first.getKey()), (Long)first.getValue(), Permission.getKeyClass((String)second.getKey()), (Long)second.getValue()));
            } else {
                this.listeners.forEach(listener -> listener.invalidateObject(false, Permission.getKeyClass((String)first.getKey()), (Long)first.getValue()));
            }
        }
    }
}

