/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.batik.util.gui.resource.ResourceFormatException;

public class ResourceManager {
    protected ResourceBundle[] bundles;
    protected String bundleNames;

    public ResourceManager(ResourceBundle ... resourceBundleArray) {
        this.bundles = resourceBundleArray;
        this.bundleNames = "";
        String string = "";
        for (ResourceBundle resourceBundle : this.bundles) {
            this.bundleNames = this.bundleNames + string + resourceBundle.getClass().getName();
            string = "; ";
        }
    }

    public String getString(String string) throws MissingResourceException {
        MissingResourceException missingResourceException = null;
        String string2 = null;
        for (ResourceBundle resourceBundle : this.bundles) {
            try {
                string2 = resourceBundle.getString(string);
                missingResourceException = null;
            }
            catch (MissingResourceException missingResourceException2) {
                missingResourceException = missingResourceException2;
                continue;
            }
            if (string2 != null) break;
        }
        if (missingResourceException != null) {
            throw missingResourceException;
        }
        return string2;
    }

    public String getStringOrNull(String string) {
        try {
            return this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public List getStringList(String string) throws MissingResourceException {
        return this.getStringList(string, " \t\n\r\f", false);
    }

    public List getStringList(String string, String string2) throws MissingResourceException {
        return this.getStringList(string, string2, false);
    }

    public List getStringList(String string, String string2, boolean bl) throws MissingResourceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString(string), string2, bl);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public boolean getBoolean(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ResourceFormatException("Malformed boolean", this.bundleNames, string);
    }

    public int getInteger(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ResourceFormatException("Malformed integer", this.bundleNames, string);
        }
    }

    public int getCharacter(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        if (string2 == null || string2.length() == 0) {
            throw new ResourceFormatException("Malformed character", this.bundleNames, string);
        }
        return string2.charAt(0);
    }
}

