/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import net.sf.mpxj.common.CharsetHelper;

public class PhoenixInputStream
extends InputStream {
    private final InputStream m_stream;
    private final Map<String, String> m_properties = new HashMap<String, String>();

    public PhoenixInputStream(InputStream inputStream) throws IOException {
        this.m_stream = this.prepareInputStream(inputStream);
    }

    @Override
    public int read() throws IOException {
        return this.m_stream.read();
    }

    public String getVersion() {
        return this.m_properties.get("VERSION");
    }

    public boolean isCompressed() {
        String string = this.m_properties.get("COMPRESSION");
        return string != null && string.equals("yes");
    }

    private InputStream prepareInputStream(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.readHeaderProperties(bufferedInputStream);
        FilterInputStream filterInputStream = this.isCompressed() ? new InflaterInputStream(bufferedInputStream) : bufferedInputStream;
        return filterInputStream;
    }

    private String readHeaderString(BufferedInputStream bufferedInputStream) throws IOException {
        int n = 100;
        bufferedInputStream.mark(n);
        byte[] byArray = new byte[n];
        bufferedInputStream.read(byArray);
        Charset charset = CharsetHelper.UTF8;
        String string = new String(byArray, charset);
        int n2 = string.indexOf("PPX!!!!|");
        int n3 = string.indexOf("|!!!!XPP");
        if (n2 != 0 || n3 == -1) {
            throw new IOException("File format not recognised");
        }
        int n4 = n3 + 9;
        bufferedInputStream.reset();
        bufferedInputStream.skip(n4);
        return string.substring(n2 + 8, n3);
    }

    private void readHeaderProperties(BufferedInputStream bufferedInputStream) throws IOException {
        String string = this.readHeaderString(bufferedInputStream);
        for (String string2 : string.split("\\|")) {
            String[] stringArray = string2.split("=");
            this.m_properties.put(stringArray[0], stringArray[1]);
        }
    }
}

