/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileVersion;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ProjectFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class ProjectProperties
extends ProjectEntity
implements FieldContainer {
    private Object[] m_array = new Object[ProjectField.MAX_VALUE];
    private List<FieldListener> m_listeners;
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final char DEFAULT_DATE_SEPARATOR = '/';
    private static final char DEFAULT_THOUSANDS_SEPARATOR = ',';
    private static final char DEFAULT_DECIMAL_SEPARATOR = '.';
    private static final String DEFAULT_CURRENCY_SYMBOL = "$";
    private static final Double DEFAULT_COST = 0.0;
    private static final char DEFAULT_MPX_DELIMITER = ',';
    private static final Integer DEFAULT_CRITICAL_SLACK_LIMIT = 0;
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = 0;
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = 1;
    private static final Day DEFAULT_WEEK_START_DAY = Day.MONDAY;
    private static final Duration DEFAULT_WORK = Duration.getInstance(0, TimeUnit.HOURS);
    private static final Double DEFAULT_WORK2 = 0.0;
    private static final Duration DEFAULT_DURATION = Duration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Double DEFAULT_PERCENT_COMPLETE = 0.0;
    private static final String DEFAULT_CALENDAR_NAME = "Standard";
    private static final Integer DEFAULT_MINUTES_PER_DAY = 480;
    private static final Integer DEFAULT_DAYS_PER_MONTH = 20;
    private static final Integer DEFAULT_MINUTES_PER_WEEK = 2400;

    ProjectProperties(ProjectFile projectFile) {
        super(projectFile);
        this.setMpxDelimiter(',');
        this.setMpxProgramName("Microsoft Project for Windows");
        this.setMpxFileVersion(FileVersion.VERSION_4_0);
        this.setMpxCodePage(CodePage.ANSI);
        this.setCurrencySymbol(DEFAULT_CURRENCY_SYMBOL);
        this.setSymbolPosition(CurrencySymbolPosition.BEFORE);
        this.setCurrencyDigits(2);
        this.setThousandsSeparator(',');
        this.setDecimalSeparator('.');
        this.setDateOrder(DateOrder.DMY);
        this.setTimeFormat(ProjectTimeFormat.TWELVE_HOUR);
        this.setDefaultStartTime(DateHelper.getTimeFromMinutesPastMidnight(480));
        this.setDateSeparator('/');
        this.setTimeSeparator(':');
        this.setAMText("am");
        this.setPMText("pm");
        this.setDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setBarTextDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setMinutesPerDay(480);
        this.setMinutesPerWeek(2400);
        this.setDefaultStandardRate(new Rate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new Rate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setDefaultCalendarName(DEFAULT_CALENDAR_NAME);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(new Date());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
    }

    public TimeUnit getDefaultDurationUnits() {
        return (TimeUnit)this.getCachedValue(ProjectField.DEFAULT_DURATION_UNITS);
    }

    public void setDefaultDurationUnits(TimeUnit timeUnit) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_UNITS, timeUnit);
    }

    public boolean getDefaultDurationIsFixed() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.DEFAULT_DURATION_IS_FIXED));
    }

    public void setDefaultDurationIsFixed(boolean bl) {
        this.set((FieldType)ProjectField.DEFAULT_DURATION_IS_FIXED, bl);
    }

    public TimeUnit getDefaultWorkUnits() {
        return (TimeUnit)this.getCachedValue(ProjectField.DEFAULT_WORK_UNITS);
    }

    public void setDefaultWorkUnits(TimeUnit timeUnit) {
        this.set((FieldType)ProjectField.DEFAULT_WORK_UNITS, timeUnit);
    }

    public Rate getDefaultStandardRate() {
        return (Rate)this.getCachedValue(ProjectField.DEFAULT_STANDARD_RATE);
    }

    public void setDefaultStandardRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_STANDARD_RATE, rate);
    }

    public Rate getDefaultOvertimeRate() {
        return (Rate)this.getCachedValue(ProjectField.DEFAULT_OVERTIME_RATE);
    }

    public void setDefaultOvertimeRate(Rate rate) {
        this.set((FieldType)ProjectField.DEFAULT_OVERTIME_RATE, rate);
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS));
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean bl) {
        this.set((FieldType)ProjectField.UPDATING_TASK_STATUS_UPDATES_RESOURCE_STATUS, bl);
    }

    public boolean getSplitInProgressTasks() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPLIT_IN_PROGRESS_TASKS));
    }

    public void setSplitInProgressTasks(boolean bl) {
        this.set((FieldType)ProjectField.SPLIT_IN_PROGRESS_TASKS, bl);
    }

    public DateOrder getDateOrder() {
        return (DateOrder)this.getCachedValue(ProjectField.DATE_ORDER);
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.set((FieldType)ProjectField.DATE_ORDER, dateOrder);
    }

    public ProjectTimeFormat getTimeFormat() {
        return (ProjectTimeFormat)this.getCachedValue(ProjectField.TIME_FORMAT);
    }

    public void setTimeFormat(ProjectTimeFormat projectTimeFormat) {
        this.set((FieldType)ProjectField.TIME_FORMAT, projectTimeFormat);
    }

    public Date getDefaultStartTime() {
        return (Date)this.getCachedValue(ProjectField.DEFAULT_START_TIME);
    }

    public void setDefaultStartTime(Date date) {
        this.set((FieldType)ProjectField.DEFAULT_START_TIME, date);
    }

    public char getDateSeparator() {
        return this.getCachedCharValue(ProjectField.DATE_SEPARATOR, '/');
    }

    public void setDateSeparator(char c) {
        this.set((FieldType)ProjectField.DATE_SEPARATOR, Character.valueOf(c));
    }

    public char getTimeSeparator() {
        return this.getCachedCharValue(ProjectField.TIME_SEPARATOR, ':');
    }

    public void setTimeSeparator(char c) {
        this.set((FieldType)ProjectField.TIME_SEPARATOR, Character.valueOf(c));
    }

    public String getAMText() {
        return (String)this.getCachedValue(ProjectField.AM_TEXT);
    }

    public void setAMText(String string) {
        this.set((FieldType)ProjectField.AM_TEXT, string);
    }

    public String getPMText() {
        return (String)this.getCachedValue(ProjectField.PM_TEXT);
    }

    public void setPMText(String string) {
        this.set((FieldType)ProjectField.PM_TEXT, string);
    }

    public ProjectDateFormat getDateFormat() {
        return (ProjectDateFormat)this.getCachedValue(ProjectField.DATE_FORMAT);
    }

    public void setDateFormat(ProjectDateFormat projectDateFormat) {
        this.set((FieldType)ProjectField.DATE_FORMAT, projectDateFormat);
    }

    public ProjectDateFormat getBarTextDateFormat() {
        return (ProjectDateFormat)this.getCachedValue(ProjectField.BAR_TEXT_DATE_FORMAT);
    }

    public void setBarTextDateFormat(ProjectDateFormat projectDateFormat) {
        this.set((FieldType)ProjectField.BAR_TEXT_DATE_FORMAT, projectDateFormat);
    }

    public Date getDefaultEndTime() {
        return (Date)this.getCachedValue(ProjectField.DEFAULT_END_TIME);
    }

    public void setDefaultEndTime(Date date) {
        this.set((FieldType)ProjectField.DEFAULT_END_TIME, date);
    }

    public void setProjectTitle(String string) {
        this.set((FieldType)ProjectField.PROJECT_TITLE, string);
    }

    public String getProjectTitle() {
        return (String)this.getCachedValue(ProjectField.PROJECT_TITLE);
    }

    public void setCompany(String string) {
        this.set((FieldType)ProjectField.COMPANY, string);
    }

    public String getCompany() {
        return (String)this.getCachedValue(ProjectField.COMPANY);
    }

    public void setManager(String string) {
        this.set((FieldType)ProjectField.MANAGER, string);
    }

    public String getManager() {
        return (String)this.getCachedValue(ProjectField.MANAGER);
    }

    public void setDefaultCalendarName(String string) {
        if (string == null || string.length() == 0) {
            string = DEFAULT_CALENDAR_NAME;
        }
        this.set((FieldType)ProjectField.DEFAULT_CALENDAR_NAME, string);
    }

    public String getDefaultCalendarName() {
        return (String)this.getCachedValue(ProjectField.DEFAULT_CALENDAR_NAME);
    }

    public void setStartDate(Date date) {
        this.set((FieldType)ProjectField.START_DATE, date);
    }

    public Date getStartDate() {
        Date date = (Date)this.getCachedValue(ProjectField.START_DATE);
        if (date == null) {
            date = this.getParentFile().getStartDate();
        }
        return date;
    }

    public Date getFinishDate() {
        Date date = (Date)this.getCachedValue(ProjectField.FINISH_DATE);
        if (date == null) {
            date = this.getParentFile().getFinishDate();
        }
        return date;
    }

    public void setFinishDate(Date date) {
        this.set((FieldType)ProjectField.FINISH_DATE, date);
    }

    public ScheduleFrom getScheduleFrom() {
        return (ScheduleFrom)this.getCachedValue(ProjectField.SCHEDULE_FROM);
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.set((FieldType)ProjectField.SCHEDULE_FROM, scheduleFrom);
    }

    public Date getCurrentDate() {
        return (Date)this.getCachedValue(ProjectField.CURRENT_DATE);
    }

    public void setCurrentDate(Date date) {
        this.set((FieldType)ProjectField.CURRENT_DATE, date);
    }

    public String getComments() {
        return (String)this.getCachedValue(ProjectField.COMMENTS);
    }

    public void setComments(String string) {
        this.set((FieldType)ProjectField.COMMENTS, string);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(ProjectField.COST);
    }

    public void setCost(Number number) {
        this.set((FieldType)ProjectField.COST, number);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)ProjectField.BASELINE_COST, number);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(ProjectField.BASELINE_COST);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)ProjectField.ACTUAL_COST, number);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(ProjectField.ACTUAL_COST);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)ProjectField.WORK, duration);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(ProjectField.WORK);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)ProjectField.BASELINE_WORK, duration);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(ProjectField.BASELINE_WORK);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)ProjectField.ACTUAL_WORK, duration);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(ProjectField.ACTUAL_WORK);
    }

    public Number getWork2() {
        return (Number)this.getCachedValue(ProjectField.WORK2);
    }

    public void setWork2(Number number) {
        this.set((FieldType)ProjectField.WORK2, number);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(ProjectField.DURATION);
    }

    public void setDuration(Duration duration) {
        this.set((FieldType)ProjectField.DURATION, duration);
    }

    public Duration getBaselineDuration() {
        return (Duration)this.getCachedValue(ProjectField.BASELINE_DURATION);
    }

    public void setBaselineDuration(Duration duration) {
        this.set((FieldType)ProjectField.BASELINE_DURATION, duration);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(ProjectField.ACTUAL_DURATION);
    }

    public void setActualDuration(Duration duration) {
        this.set((FieldType)ProjectField.ACTUAL_DURATION, duration);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(ProjectField.PERCENTAGE_COMPLETE);
    }

    public void setPercentageComplete(Number number) {
        this.set((FieldType)ProjectField.PERCENTAGE_COMPLETE, number);
    }

    public void setBaselineStart(Date date) {
        this.set((FieldType)ProjectField.BASELINE_START, date);
    }

    public Date getBaselineStart() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_START);
    }

    public void setBaselineFinish(Date date) {
        this.set((FieldType)ProjectField.BASELINE_FINISH, date);
    }

    public Date getBaselineFinish() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_FINISH);
    }

    public void setActualStart(Date date) {
        this.set((FieldType)ProjectField.ACTUAL_START, date);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(ProjectField.ACTUAL_START);
    }

    public void setActualFinish(Date date) {
        this.set((FieldType)ProjectField.ACTUAL_FINISH, date);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(ProjectField.ACTUAL_FINISH);
    }

    public Duration getStartVariance() {
        return (Duration)this.getCachedValue(ProjectField.START_VARIANCE);
    }

    public void setStartVariance(Duration duration) {
        this.set((FieldType)ProjectField.START_VARIANCE, duration);
    }

    public Duration getFinishVariance() {
        return (Duration)this.getCachedValue(ProjectField.FINISH_VARIANCE);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)ProjectField.FINISH_VARIANCE, duration);
    }

    public String getSubject() {
        return (String)this.getCachedValue(ProjectField.SUBJECT);
    }

    public void setSubject(String string) {
        this.set((FieldType)ProjectField.SUBJECT, string);
    }

    public String getAuthor() {
        return (String)this.getCachedValue(ProjectField.AUTHOR);
    }

    public void setAuthor(String string) {
        this.set((FieldType)ProjectField.AUTHOR, string);
    }

    public String getKeywords() {
        return (String)this.getCachedValue(ProjectField.KEYWORDS);
    }

    public void setKeywords(String string) {
        this.set((FieldType)ProjectField.KEYWORDS, string);
    }

    public void setCurrencySymbol(String string) {
        if (string == null) {
            string = DEFAULT_CURRENCY_SYMBOL;
        }
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL, string);
    }

    public String getCurrencySymbol() {
        return (String)this.getCachedValue(ProjectField.CURRENCY_SYMBOL);
    }

    public void setSymbolPosition(CurrencySymbolPosition currencySymbolPosition) {
        this.set((FieldType)ProjectField.CURRENCY_SYMBOL_POSITION, currencySymbolPosition);
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return (CurrencySymbolPosition)this.getCachedValue(ProjectField.CURRENCY_SYMBOL_POSITION);
    }

    public void setCurrencyDigits(Integer n) {
        this.set((FieldType)ProjectField.CURRENCY_DIGITS, n);
    }

    public Integer getCurrencyDigits() {
        return (Integer)this.getCachedValue(ProjectField.CURRENCY_DIGITS);
    }

    public void setThousandsSeparator(char c) {
        this.set((FieldType)ProjectField.THOUSANDS_SEPARATOR, Character.valueOf(c));
    }

    public char getThousandsSeparator() {
        return this.getCachedCharValue(ProjectField.THOUSANDS_SEPARATOR, ',');
    }

    public void setDecimalSeparator(char c) {
        this.set((FieldType)ProjectField.DECIMAL_SEPARATOR, Character.valueOf(c));
    }

    public char getDecimalSeparator() {
        return this.getCachedCharValue(ProjectField.DECIMAL_SEPARATOR, '.');
    }

    public boolean getProjectExternallyEdited() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.PROJECT_EXTERNALLY_EDITED));
    }

    public void setProjectExternallyEdited(boolean bl) {
        this.set((FieldType)ProjectField.PROJECT_EXTERNALLY_EDITED, bl);
    }

    public String getCategory() {
        return (String)this.getCachedValue(ProjectField.CATEGORY);
    }

    public void setCategory(String string) {
        this.set((FieldType)ProjectField.CATEGORY, string);
    }

    public Number getDaysPerMonth() {
        return (Number)this.getCachedValue(ProjectField.DAYS_PER_MONTH);
    }

    public void setDaysPerMonth(Number number) {
        if (number != null) {
            this.set((FieldType)ProjectField.DAYS_PER_MONTH, number);
        }
    }

    public Number getMinutesPerDay() {
        return (Number)this.getCachedValue(ProjectField.MINUTES_PER_DAY);
    }

    public void setMinutesPerDay(Number number) {
        if (number != null) {
            this.set((FieldType)ProjectField.MINUTES_PER_DAY, number);
        }
    }

    public Number getMinutesPerWeek() {
        return (Number)this.getCachedValue(ProjectField.MINUTES_PER_WEEK);
    }

    public void setMinutesPerWeek(Number number) {
        if (number != null) {
            this.set((FieldType)ProjectField.MINUTES_PER_WEEK, number);
        }
    }

    public Number getMinutesPerMonth() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth());
    }

    public Number getMinutesPerYear() {
        return NumberHelper.getInt(this.getMinutesPerDay()) * NumberHelper.getInt(this.getDaysPerMonth()) * 12;
    }

    public boolean getFiscalYearStart() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.FISCAL_YEAR_START));
    }

    public void setFiscalYearStart(boolean bl) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START, bl);
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD);
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public boolean getRemoveFileProperties() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.REMOVE_FILE_PROPERTIES));
    }

    public void setRemoveFileProperties(boolean bl) {
        this.set((FieldType)ProjectField.REMOVE_FILE_PROPERTIES, bl);
    }

    public boolean getMoveCompletedEndsBack() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_COMPLETED_ENDS_BACK));
    }

    public void setMoveCompletedEndsBack(boolean bl) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_BACK, bl);
    }

    public boolean getNewTasksEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASKS_ESTIMATED));
    }

    public void setNewTasksEstimated(boolean bl) {
        this.set((FieldType)ProjectField.NEW_TASKS_ESTIMATED, bl);
    }

    public boolean getSpreadActualCost() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPREAD_ACTUAL_COST));
    }

    public void setSpreadActualCost(boolean bl) {
        this.set((FieldType)ProjectField.SPREAD_ACTUAL_COST, bl);
    }

    public boolean getMultipleCriticalPaths() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MULTIPLE_CRITICAL_PATHS));
    }

    public void setMultipleCriticalPaths(boolean bl) {
        this.set((FieldType)ProjectField.MULTIPLE_CRITICAL_PATHS, bl);
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS));
    }

    public void setAutoAddNewResourcesAndTasks(boolean bl) {
        this.set((FieldType)ProjectField.AUTO_ADD_NEW_RESOURCES_AND_TASKS, bl);
    }

    public Date getLastSaved() {
        return (Date)this.getCachedValue(ProjectField.LAST_SAVED);
    }

    public void setLastSaved(Date date) {
        this.set((FieldType)ProjectField.LAST_SAVED, date);
    }

    public Date getStatusDate() {
        return (Date)this.getCachedValue(ProjectField.STATUS_DATE);
    }

    public void setStatusDate(Date date) {
        this.set((FieldType)ProjectField.STATUS_DATE, date);
    }

    public boolean getMoveRemainingStartsBack() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_REMAINING_STARTS_BACK));
    }

    public void setMoveRemainingStartsBack(boolean bl) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_BACK, bl);
    }

    public boolean getAutolink() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTO_LINK));
    }

    public void setAutolink(boolean bl) {
        this.set((FieldType)ProjectField.AUTO_LINK, bl);
    }

    public boolean getMicrosoftProjectServerURL() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MICROSOFT_PROJECT_SERVER_URL));
    }

    public void setMicrosoftProjectServerURL(boolean bl) {
        this.set((FieldType)ProjectField.MICROSOFT_PROJECT_SERVER_URL, bl);
    }

    public boolean getHonorConstraints() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.HONOR_CONSTRAINTS));
    }

    public void setHonorConstraints(boolean bl) {
        this.set((FieldType)ProjectField.HONOR_CONSTRAINTS, bl);
    }

    public boolean getAdminProject() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.ADMIN_PROJECT));
    }

    public void setAdminProject(boolean bl) {
        this.set((FieldType)ProjectField.ADMIN_PROJECT, bl);
    }

    public boolean getInsertedProjectsLikeSummary() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY));
    }

    public void setInsertedProjectsLikeSummary(boolean bl) {
        this.set((FieldType)ProjectField.INSERTED_PROJECTS_LIKE_SUMMARY, bl);
    }

    public String getName() {
        return (String)this.getCachedValue(ProjectField.NAME);
    }

    public void setName(String string) {
        this.set((FieldType)ProjectField.NAME, string);
    }

    public boolean getSpreadPercentComplete() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SPREAD_PERCENT_COMPLETE));
    }

    public void setSpreadPercentComplete(boolean bl) {
        this.set((FieldType)ProjectField.SPREAD_PERCENT_COMPLETE, bl);
    }

    public boolean getMoveCompletedEndsForward() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_COMPLETED_ENDS_FORWARD));
    }

    public void setMoveCompletedEndsForward(boolean bl) {
        this.set((FieldType)ProjectField.MOVE_COMPLETED_ENDS_FORWARD, bl);
    }

    public boolean getEditableActualCosts() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.EDITABLE_ACTUAL_COSTS));
    }

    public void setEditableActualCosts(boolean bl) {
        this.set((FieldType)ProjectField.EDITABLE_ACTUAL_COSTS, bl);
    }

    public String getUniqueID() {
        return (String)this.getCachedValue(ProjectField.UNIQUE_ID);
    }

    public void setUniqueID(String string) {
        this.set((FieldType)ProjectField.UNIQUE_ID, string);
    }

    public Integer getRevision() {
        return (Integer)this.getCachedValue(ProjectField.REVISION);
    }

    public boolean getNewTasksEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASKS_EFFORT_DRIVEN));
    }

    public void setNewTasksEffortDriven(boolean bl) {
        this.set((FieldType)ProjectField.NEW_TASKS_EFFORT_DRIVEN, bl);
    }

    public void setRevision(Integer n) {
        this.set((FieldType)ProjectField.REVISION, n);
    }

    public boolean getMoveRemainingStartsForward() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.MOVE_REMAINING_STARTS_FORWARD));
    }

    public void setMoveRemainingStartsForward(boolean bl) {
        this.set((FieldType)ProjectField.MOVE_REMAINING_STARTS_FORWARD, bl);
    }

    public boolean getActualsInSync() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.ACTUALS_IN_SYNC));
    }

    public void setActualsInSync(boolean bl) {
        this.set((FieldType)ProjectField.ACTUALS_IN_SYNC, bl);
    }

    public TaskType getDefaultTaskType() {
        return (TaskType)this.getCachedValue(ProjectField.DEFAULT_TASK_TYPE);
    }

    public void setDefaultTaskType(TaskType taskType) {
        this.set((FieldType)ProjectField.DEFAULT_TASK_TYPE, taskType);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(ProjectField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)ProjectField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public Date getCreationDate() {
        return (Date)this.getCachedValue(ProjectField.CREATION_DATE);
    }

    public void setCreationDate(Date date) {
        this.set((FieldType)ProjectField.CREATION_DATE, date);
    }

    public Date getExtendedCreationDate() {
        return (Date)this.getCachedValue(ProjectField.EXTENDED_CREATION_DATE);
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(ProjectField.DEFAULT_FIXED_COST_ACCRUAL);
    }

    public void setDefaultFixedCostAccrual(AccrueType accrueType) {
        this.set((FieldType)ProjectField.DEFAULT_FIXED_COST_ACCRUAL, accrueType);
    }

    public void setExtendedCreationDate(Date date) {
        this.set((FieldType)ProjectField.EXTENDED_CREATION_DATE, date);
    }

    public Integer getCriticalSlackLimit() {
        return (Integer)this.getCachedValue(ProjectField.CRITICAL_SLACK_LIMIT);
    }

    public void setCriticalSlackLimit(Integer n) {
        this.set((FieldType)ProjectField.CRITICAL_SLACK_LIMIT, n);
    }

    public Integer getBaselineForEarnedValue() {
        return (Integer)this.getCachedValue(ProjectField.BASELINE_FOR_EARNED_VALUE);
    }

    public void setBaselineForEarnedValue(Integer n) {
        this.set((FieldType)ProjectField.BASELINE_FOR_EARNED_VALUE, n);
    }

    public Integer getFiscalYearStartMonth() {
        return (Integer)this.getCachedValue(ProjectField.FISCAL_YEAR_START_MONTH);
    }

    public void setFiscalYearStartMonth(Integer n) {
        this.set((FieldType)ProjectField.FISCAL_YEAR_START_MONTH, n);
    }

    public boolean getNewTaskStartIsProjectStart() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.NEW_TASK_START_IS_PROJECT_START));
    }

    public void setNewTaskStartIsProjectStart(boolean bl) {
        this.set((FieldType)ProjectField.NEW_TASK_START_IS_PROJECT_START, bl);
    }

    public Day getWeekStartDay() {
        return (Day)this.getCachedValue(ProjectField.WEEK_START_DAY);
    }

    public void setWeekStartDay(Day day) {
        this.set((FieldType)ProjectField.WEEK_START_DAY, day);
    }

    public void setCalculateMultipleCriticalPaths(boolean bl) {
        this.set((FieldType)ProjectField.CALCULATE_MULTIPLE_CRITICAL_PATHS, bl);
    }

    public boolean getCalculateMultipleCriticalPaths() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.CALCULATE_MULTIPLE_CRITICAL_PATHS));
    }

    public String getCurrencyCode() {
        return (String)this.getCachedValue(ProjectField.CURRENCY_CODE);
    }

    public void setCurrencyCode(String string) {
        this.set((FieldType)ProjectField.CURRENCY_CODE, string);
    }

    public void setCustomProperties(Map<String, Object> map) {
        this.set((FieldType)ProjectField.CUSTOM_PROPERTIES, map);
    }

    public Map<String, Object> getCustomProperties() {
        return (Map)this.getCachedValue(ProjectField.CUSTOM_PROPERTIES);
    }

    public void setHyperlinkBase(String string) {
        this.set((FieldType)ProjectField.HYPERLINK_BASE, string);
    }

    public String getHyperlinkBase() {
        return (String)this.getCachedValue(ProjectField.HYPERLINK_BASE);
    }

    public boolean getShowProjectSummaryTask() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.SHOW_PROJECT_SUMMARY_TASK));
    }

    public void setShowProjectSummaryTask(boolean bl) {
        this.set((FieldType)ProjectField.SHOW_PROJECT_SUMMARY_TASK, bl);
    }

    public Date getBaselineDate() {
        return (Date)this.getCachedValue(ProjectField.BASELINE_DATE);
    }

    public void setBaselineDate(Date date) {
        this.set((FieldType)ProjectField.BASELINE_DATE, date);
    }

    public Date getBaselineDate(int n) {
        return (Date)this.getCachedValue(this.selectField(ProjectFieldLists.BASELINE_DATES, n));
    }

    public void setBaselineDate(int n, Date date) {
        this.set((FieldType)this.selectField(ProjectFieldLists.BASELINE_DATES, n), date);
    }

    public String getTemplate() {
        return (String)this.getCachedValue(ProjectField.TEMPLATE);
    }

    public void setTemplate(String string) {
        this.set((FieldType)ProjectField.TEMPLATE, string);
    }

    public String getLastAuthor() {
        return (String)this.getCachedValue(ProjectField.LAST_AUTHOR);
    }

    public void setLastAuthor(String string) {
        this.set((FieldType)ProjectField.LAST_AUTHOR, string);
    }

    public Date getLastPrinted() {
        return (Date)this.getCachedValue(ProjectField.LASTPRINTED);
    }

    public void setLastPrinted(Date date) {
        this.set((FieldType)ProjectField.LASTPRINTED, date);
    }

    public String getShortApplicationName() {
        return (String)this.getCachedValue(ProjectField.SHORT_APPLICATION_NAME);
    }

    public void setShortApplicationName(String string) {
        this.set((FieldType)ProjectField.SHORT_APPLICATION_NAME, string);
    }

    public Integer getEditingTime() {
        return (Integer)this.getCachedValue(ProjectField.EDITING_TIME);
    }

    public void setEditingTime(Integer n) {
        this.set((FieldType)ProjectField.EDITING_TIME, n);
    }

    public String getPresentationFormat() {
        return (String)this.getCachedValue(ProjectField.PRESENTATION_FORMAT);
    }

    public void setPresentationFormat(String string) {
        this.set((FieldType)ProjectField.PRESENTATION_FORMAT, string);
    }

    public String getContentType() {
        return (String)this.getCachedValue(ProjectField.CONTENT_TYPE);
    }

    public void setContentType(String string) {
        this.set((FieldType)ProjectField.CONTENT_TYPE, string);
    }

    public String getContentStatus() {
        return (String)this.getCachedValue(ProjectField.CONTENT_STATUS);
    }

    public void setContentStatus(String string) {
        this.set((FieldType)ProjectField.CONTENT_STATUS, string);
    }

    public String getLanguage() {
        return (String)this.getCachedValue(ProjectField.LANGUAGE);
    }

    public void setLanguage(String string) {
        this.set((FieldType)ProjectField.LANGUAGE, string);
    }

    public String getDocumentVersion() {
        return (String)this.getCachedValue(ProjectField.DOCUMENT_VERSION);
    }

    public void setDocumentVersion(String string) {
        this.set((FieldType)ProjectField.DOCUMENT_VERSION, string);
    }

    public void setMpxDelimiter(char c) {
        this.set((FieldType)ProjectField.MPX_DELIMITER, Character.valueOf(c));
    }

    public char getMpxDelimiter() {
        return this.getCachedCharValue(ProjectField.MPX_DELIMITER, ',');
    }

    public void setMpxProgramName(String string) {
        this.set((FieldType)ProjectField.MPX_PROGRAM_NAME, string);
    }

    public String getMpxProgramName() {
        return (String)this.getCachedValue(ProjectField.MPX_PROGRAM_NAME);
    }

    public void setMpxFileVersion(FileVersion fileVersion) {
        this.set((FieldType)ProjectField.MPX_FILE_VERSION, fileVersion);
    }

    public FileVersion getMpxFileVersion() {
        return (FileVersion)this.getCachedValue(ProjectField.MPX_FILE_VERSION);
    }

    public void setMpxCodePage(CodePage codePage) {
        this.set((FieldType)ProjectField.MPX_CODE_PAGE, (Object)codePage);
    }

    public CodePage getMpxCodePage() {
        return (CodePage)((Object)this.getCachedValue(ProjectField.MPX_CODE_PAGE));
    }

    public void setProjectFilePath(String string) {
        this.set((FieldType)ProjectField.PROJECT_FILE_PATH, string);
    }

    public String getProjectFilePath() {
        return (String)this.getCachedValue(ProjectField.PROJECT_FILE_PATH);
    }

    public String getFullApplicationName() {
        return (String)this.getCachedValue(ProjectField.FULL_APPLICATION_NAME);
    }

    public void setFullApplicationName(String string) {
        this.set((FieldType)ProjectField.FULL_APPLICATION_NAME, string);
    }

    public Integer getApplicationVersion() {
        return (Integer)this.getCachedValue(ProjectField.APPLICATION_VERSION);
    }

    public void setApplicationVersion(Integer n) {
        this.set((FieldType)ProjectField.APPLICATION_VERSION, n);
    }

    public Integer getMppFileType() {
        return (Integer)this.getCachedValue(ProjectField.MPP_FILE_TYPE);
    }

    public void setMppFileType(Integer n) {
        this.set((FieldType)ProjectField.MPP_FILE_TYPE, n);
    }

    public boolean getAutoFilter() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ProjectField.AUTOFILTER));
    }

    public void setAutoFilter(boolean bl) {
        this.set((FieldType)ProjectField.AUTOFILTER, bl);
    }

    public String getFileApplication() {
        return (String)this.getCachedValue(ProjectField.FILE_APPLICATION);
    }

    public void setFileApplication(String string) {
        this.set((FieldType)ProjectField.FILE_APPLICATION, string);
    }

    public String getFileType() {
        return (String)this.getCachedValue(ProjectField.FILE_TYPE);
    }

    public void setFileType(String string) {
        this.set((FieldType)ProjectField.FILE_TYPE, string);
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    private ProjectField selectField(ProjectField[] projectFieldArray, int n) {
        if (n < 1 || n > projectFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return projectFieldArray[n - 1];
    }

    private char getCachedCharValue(FieldType fieldType, char c) {
        Character c2 = (Character)this.getCachedValue(fieldType);
        return c2 == null ? c : c2.charValue();
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        return this.getCachedValue(fieldType);
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            this.m_array[n] = object;
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }
}

