/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.timescale;

import com.projectlibre1.timescale.CalendarUtil;
import com.projectlibre1.timescale.ExtendedDateFormat;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.Environment;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TimeScale {
    protected int minWidth;
    protected int tableMinWidth;
    protected int normalMinWidth;
    protected long minDuration;
    protected int number1;
    protected int number2;
    protected int calendarField1;
    protected int calendarField2;
    protected double ratio = -1.0;
    protected String pattern1;
    protected String pattern2;
    protected int trunc1 = -1;
    protected int trunc2 = -1;
    protected boolean upperCase1 = false;
    protected boolean upperCase2 = false;
    private ExtendedDateFormat recycledDateFormat;
    private Calendar tmp = DateTime.calendarInstance();

    public TimeScale() {
        this.recycledDateFormat = DateTime.extendedUtcDateFormatInstance();
    }

    public long floor1(long l) {
        this.tmp.setTimeInMillis(l);
        this.floor(this.tmp, this.calendarField1, this.number1, -1L);
        return this.tmp.getTimeInMillis();
    }

    public long ceil1(long l) {
        this.tmp.setTimeInMillis(l);
        this.ceil(this.tmp, this.calendarField1, this.number1, -1L);
        return this.tmp.getTimeInMillis();
    }

    public void floor1(Calendar calendar) {
        this.floor(calendar, this.calendarField1, this.number1, -1L);
    }

    public void floor1(Calendar calendar, long l) {
        this.floor(calendar, this.calendarField1, this.number1, l);
    }

    public void floor2(Calendar calendar) {
        this.floor(calendar, this.calendarField2, this.number2, -1L);
    }

    public void floor2(Calendar calendar, long l) {
        this.floor(calendar, this.calendarField2, this.number2, l);
    }

    public void ceil1(Calendar calendar) {
        this.ceil(calendar, this.calendarField1, this.number1, -1L);
    }

    public void ceil1(Calendar calendar, long l) {
        this.ceil(calendar, this.calendarField1, this.number1, l);
    }

    public void ceil2(Calendar calendar) {
        this.ceil(calendar, this.calendarField2, this.number2, -1L);
    }

    public void ceil2(Calendar calendar, long l) {
        this.ceil(calendar, this.calendarField2, this.number2, l);
    }

    protected void floor(Calendar calendar, int n, int n2, long l) {
        CalendarUtil.floor(calendar, n, n2);
    }

    protected void ceil(Calendar calendar, int n, int n2, long l) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        this.floor(gregorianCalendar, n, n2, l);
        if (gregorianCalendar.getTimeInMillis() == calendar.getTimeInMillis()) {
            return;
        }
        this.floor(calendar, n, n2, l);
        calendar.add(n, n2);
    }

    public void increment1(Calendar calendar) {
        calendar.add(this.calendarField1, this.number1);
    }

    public void increment2(Calendar calendar) {
        calendar.add(this.calendarField2, this.number2);
    }

    public String getText1(long l) {
        this.tmp.setTimeInMillis(l);
        this.recycledDateFormat.applyPattern(this.pattern1);
        String string = this.recycledDateFormat.format(this.tmp.getTime());
        if (this.trunc1 >= 0) {
            int n;
            if (Environment.isChinese() && (n = string.length()) > 2) {
                return string.substring(n - this.trunc1);
            }
            string = string.substring(0, this.trunc1);
        }
        if (this.upperCase1) {
            string = string.toUpperCase();
        }
        return string;
    }

    public String getText2(long l) {
        this.tmp.setTimeInMillis(l);
        this.recycledDateFormat.applyPattern(this.pattern2);
        String string = this.recycledDateFormat.format(this.tmp.getTime());
        if (this.trunc2 >= 0) {
            string = string.substring(0, this.trunc2);
        }
        if (this.upperCase2) {
            string = string.toUpperCase();
        }
        return string;
    }

    public void toggleWidth(boolean bl) {
        if (this.minWidth == this.normalMinWidth != bl) {
            this.minWidth = bl ? this.normalMinWidth : this.tableMinWidth;
            this.updateRatio();
        }
    }

    public double getRatio() {
        if (this.ratio == -1.0) {
            this.updateRatio();
        }
        return this.ratio;
    }

    private void updateRatio() {
        this.minDuration = CalendarUtil.getMinDuration(this.calendarField1) * (long)this.number1;
        this.ratio = (double)this.minWidth / (double)this.minDuration;
    }

    public double toTime(double d) {
        return d / this.getRatio();
    }

    public double toX(double d) {
        return d * this.getRatio();
    }

    public void setCalendarField1(int n) {
        this.calendarField1 = n;
    }

    public void setCalendarField2(int n) {
        this.calendarField2 = n;
    }

    public void setNormalMinWidth(int n) {
        this.normalMinWidth = n;
        this.minWidth = n;
    }

    public void setNormalMinWidthChinese(int n) {
        if (Environment.isChinese()) {
            this.normalMinWidth = n;
            this.minWidth = n;
        }
    }

    public void setNumber1(int n) {
        this.number1 = n;
    }

    public void setNumber2(int n) {
        this.number2 = n;
    }

    public void setPattern1(String string) {
        this.pattern1 = string;
    }

    public void setPattern2(String string) {
        this.pattern2 = string;
    }

    public void setTrunc1(int n) {
        this.trunc1 = n;
    }

    public void setTrunc2(int n) {
        this.trunc2 = n;
    }

    public void setUpperCase1(boolean bl) {
        this.upperCase1 = bl;
    }

    public void setUpperCase2(boolean bl) {
        this.upperCase2 = bl;
    }

    public void setTableMinWidth(int n) {
        this.tableMinWidth = n;
    }

    public Object clone() {
        TimeScale timeScale = new TimeScale();
        timeScale.minWidth = this.minWidth;
        timeScale.tableMinWidth = this.tableMinWidth;
        timeScale.normalMinWidth = this.normalMinWidth;
        timeScale.minDuration = this.minDuration;
        timeScale.number1 = this.number1;
        timeScale.number2 = this.number2;
        timeScale.calendarField1 = this.calendarField1;
        timeScale.calendarField2 = this.calendarField2;
        timeScale.ratio = this.ratio;
        timeScale.pattern1 = this.pattern1;
        timeScale.pattern2 = this.pattern2;
        timeScale.trunc1 = this.trunc1;
        timeScale.trunc2 = this.trunc2;
        timeScale.upperCase1 = this.upperCase1;
        timeScale.upperCase2 = this.upperCase2;
        return timeScale;
    }

    public long getIntervalDuration() {
        return CalendarUtil.getMinDuration(this.calendarField1) * (long)this.number1;
    }

    public int getMinWidth() {
        return this.minWidth;
    }
}

