/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.grouping.core.hierarchy;

import com.projectlibre1.grouping.core.LazyParent;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeBridge;
import com.projectlibre1.grouping.core.event.HierarchyEvent;
import com.projectlibre1.grouping.core.event.HierarchyListener;
import com.projectlibre1.grouping.core.hierarchy.NodeHierarchy;
import com.projectlibre1.pm.key.HasKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;

public abstract class AbstractMutableNodeHierarchy
implements NodeHierarchy {
    protected EventListenerList hierarchyListenerList = new EventListenerList();
    protected int updateLevel = 0;

    @Override
    public abstract Object getRoot();

    @Override
    public Object getChild(Object object, int n) {
        return ((Node)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((Node)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((Node)object).getIndex((Node)object2);
    }

    @Override
    public int getIndexOfNode(Node node, boolean bl) {
        return this.getIndexOfNode((Node)this.getRoot(), node, new Counter(), bl);
    }

    @Override
    public Iterator iterator(Node node) {
        NodeBridge nodeBridge = node != null && node instanceof NodeBridge ? (NodeBridge)node : (NodeBridge)this.getRoot();
        return IteratorUtils.asIterator(nodeBridge.preorderEnumeration());
    }

    @Override
    public Iterator iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator shallowIterator(int n, boolean bl) {
        return new ShallowPreorderInterator((TreeNode)this.getRoot(), n, bl);
    }

    private int getIndexOfNode(Node node, Node node2, Counter counter, boolean bl) {
        List list;
        if (node2 == node) {
            return counter.count;
        }
        if (!bl || !node.isVirtual()) {
            ++counter.count;
        }
        if ((list = this.getChildren(node)) == null) {
            return -1;
        }
        Iterator iterator = list.iterator();
        int n = -1;
        while (iterator.hasNext() && (n = this.getIndexOfNode(node2, (Node)iterator.next(), counter, bl)) == -1) {
        }
        return n;
    }

    @Override
    public void visitAll(Closure closure) {
        this.visitAll(null, closure);
    }

    @Override
    public void visitAll(Node node, Closure closure) {
        List list;
        if (node != null) {
            closure.execute(node);
        }
        if ((list = this.getChildren(node)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.visitAll((Node)iterator.next(), closure);
            }
        }
    }

    @Override
    public void visitAllLevelOrder(Node node, boolean bl, Closure closure) {
        this.visitAllLevelOrder(true, node, bl, closure);
    }

    public void visitAllLevelOrder(boolean bl, Node node, boolean bl2, Closure closure) {
        if (!bl && bl2 && node != null && node.getImpl() instanceof LazyParent) {
            return;
        }
        List list = this.getChildren(node);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                closure.execute(iterator.next());
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.visitAllLevelOrder(false, (Node)iterator.next(), bl2, closure);
            }
        }
    }

    @Override
    public void visitAll(Node node, boolean bl, Closure closure) {
        this.visitAll(true, node, bl, closure);
    }

    public void visitAll(boolean bl, Node node, boolean bl2, Closure closure) {
        if (!bl && bl2 && node != null && node.getImpl() instanceof LazyParent) {
            return;
        }
        List list = this.getChildren(node);
        if (list != null) {
            Iterator iterator = list.iterator();
            for (Node node2 : list) {
                closure.execute(node2);
                this.visitAll(false, node2, bl2, closure);
            }
        }
    }

    @Override
    public void visitLeaves(Node node, Closure closure) {
        if (node.isLeaf()) {
            closure.execute(node);
        } else {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                this.visitLeaves((Node)enumeration.nextElement(), closure);
            }
        }
    }

    @Override
    public Node getNext(Node node) {
        Node node2 = node;
        while ((node2 = this.getNext(node2, true)) != null && node2.isVirtual()) {
        }
        return node2;
    }

    private Node getNext(Node node, boolean bl) {
        List list;
        if (bl && (list = this.getChildren(node)) != null && list.size() > 0) {
            return (Node)list.get(0);
        }
        if (node == null) {
            return null;
        }
        Node node2 = this.getParent(node);
        list = this.getChildren(node2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != node) continue;
            if (iterator.hasNext()) {
                return (Node)iterator.next();
            }
            return this.getNext(node2, false);
        }
        return null;
    }

    @Override
    public Node getPrevious(Node node) {
        Node node2 = node;
        while ((node2 = this.getPrevious(node2, true)) != null && node2.isVirtual()) {
        }
        return node2;
    }

    private Node getPrevious(Node node, boolean bl) {
        if (node == null) {
            return null;
        }
        Node node2 = this.getParent(node);
        List list = this.getChildren(node2);
        if (bl) {
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != node) continue;
                if (listIterator.hasPrevious()) {
                    return this.getPrevious((Node)listIterator.previous(), false);
                }
                return node2;
            }
        }
        if ((list = this.getChildren(node)) != null && list.size() > 0) {
            return this.getPrevious((Node)list.get(list.size() - 1), bl);
        }
        return node;
    }

    public void dump() {
        this.dump(null, "", new Closure(){

            @Override
            public void execute(Object object) {
                System.out.println((String)object);
            }
        });
    }

    public void dump(final StringBuffer stringBuffer) {
        this.dump(null, "", new Closure(){

            @Override
            public void execute(Object object) {
                stringBuffer.append((String)object).append('\n');
            }
        });
    }

    private void dump(Node node, String string, Closure closure) {
        List list;
        if (node != null) {
            closure.execute(string + ">" + node.toString());
        }
        if ((list = this.getChildren(node)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.dump((Node)iterator.next(), string + "--", closure);
            }
        }
    }

    @Override
    public abstract Object clone();

    @Override
    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListenerList.add(HierarchyListener.class, hierarchyListener);
    }

    @Override
    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListenerList.remove(HierarchyListener.class, hierarchyListener);
    }

    @Override
    public HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])this.hierarchyListenerList.getListeners(HierarchyListener.class);
    }

    @Override
    public EventListener[] getHierarchyListeners(Class clazz) {
        return this.hierarchyListenerList.getListeners(clazz);
    }

    protected void fireStructureChanged(Object object) {
        Object[] objectArray = this.hierarchyListenerList.getListenerList();
        HierarchyEvent hierarchyEvent = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != HierarchyListener.class) continue;
            if (hierarchyEvent == null) {
                hierarchyEvent = new HierarchyEvent(object, 3, null);
            }
            ((HierarchyListener)objectArray[i + 1]).structureChanged(hierarchyEvent);
        }
    }

    protected void fireNodesChanged(Object object, Object[] objectArray, Object[] objectArray2, Object object2) {
        Object[] objectArray3 = this.hierarchyListenerList.getListenerList();
        HierarchyEvent hierarchyEvent = null;
        for (int i = 0; i < objectArray3.length; i += 2) {
            if (objectArray3[i] != HierarchyListener.class) continue;
            if (hierarchyEvent == null) {
                hierarchyEvent = new HierarchyEvent(object, 0, objectArray, objectArray2, object2);
            }
            ((HierarchyListener)objectArray3[i + 1]).nodesChanged(hierarchyEvent);
        }
    }

    protected void fireNodesInserted(Object object, Object[] objectArray, Object[] objectArray2, Object object2) {
        Object[] objectArray3 = this.hierarchyListenerList.getListenerList();
        HierarchyEvent hierarchyEvent = null;
        for (int i = 0; i < objectArray3.length; i += 2) {
            if (objectArray3[i] != HierarchyListener.class) continue;
            if (hierarchyEvent == null) {
                hierarchyEvent = new HierarchyEvent(object, 1, objectArray, objectArray2, object2);
            }
            ((HierarchyListener)objectArray3[i + 1]).nodesInserted(hierarchyEvent);
        }
    }

    protected void fireNodesRemoved(Object object, Object[] objectArray, Object[] objectArray2, Object object2) {
        Object[] objectArray3 = this.hierarchyListenerList.getListenerList();
        HierarchyEvent hierarchyEvent = null;
        for (int i = 0; i < objectArray3.length; i += 2) {
            if (objectArray3[i] != HierarchyListener.class) continue;
            if (hierarchyEvent == null) {
                hierarchyEvent = new HierarchyEvent(object, 2, objectArray, objectArray2, object2);
            }
            ((HierarchyListener)objectArray3[i + 1]).nodesRemoved(hierarchyEvent);
        }
    }

    protected void fireNodesChanged(Object object, Object[] objectArray) {
        this.fireNodesChanged(object, objectArray, null, null);
    }

    protected void fireNodesInserted(Object object, Object[] objectArray) {
        this.fireNodesInserted(object, objectArray, null, null);
    }

    protected void fireNodesRemoved(Object object, Object[] objectArray) {
        this.fireNodesRemoved(object, objectArray, null, null);
    }

    @Override
    public List toList(final boolean bl, final Predicate predicate) {
        final ArrayList arrayList = new ArrayList();
        this.visitAll(new Closure(){

            @Override
            public void execute(Object object) {
                if (predicate != null && !predicate.evaluate(((Node)object).getImpl())) {
                    return;
                }
                if (bl) {
                    arrayList.add(object);
                } else {
                    arrayList.add(((Node)object).getImpl());
                }
            }
        });
        return arrayList;
    }

    @Override
    public void renumber() {
        this.visitAll(new Closure(){
            private int index = 0;

            @Override
            public void execute(Object object) {
                HasKey hasKey;
                Node node = (Node)object;
                if (node.hasNumber() && (hasKey = (HasKey)node.getImpl()).getId() != (long)(++this.index)) {
                    hasKey.setId(this.index);
                }
            }
        });
    }

    protected synchronized void beginUpdate() {
        ++this.updateLevel;
    }

    protected synchronized void endUpdate() {
        --this.updateLevel;
    }

    protected synchronized int getUpdateLevel() {
        return this.updateLevel;
    }

    private class Counter {
        int count = 0;

        private Counter() {
        }
    }

    final class ShallowPreorderInterator
    implements Iterator<TreeNode> {
        protected Stack stack;
        protected int maxLevel;
        protected Stack<Integer> levelStack;

        public ShallowPreorderInterator(TreeNode treeNode, int n, boolean bl) {
            Vector<TreeNode> vector = new Vector<TreeNode>(1);
            vector.addElement(treeNode);
            this.stack = new Stack();
            this.stack.push(vector.elements());
            this.levelStack = new Stack();
            this.levelStack.push(0);
            this.maxLevel = n;
            if (!bl && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        @Override
        public TreeNode next() {
            Enumeration<? extends TreeNode> enumeration;
            Enumeration enumeration2 = (Enumeration)this.stack.peek();
            int n = this.levelStack.peek();
            TreeNode treeNode = (TreeNode)enumeration2.nextElement();
            Enumeration<? extends TreeNode> enumeration3 = enumeration = n == this.maxLevel ? null : treeNode.children();
            if (!enumeration2.hasMoreElements()) {
                this.stack.pop();
                this.levelStack.pop();
            }
            if (enumeration != null && enumeration.hasMoreElements()) {
                this.stack.push(enumeration);
                this.levelStack.push(n + 1);
            }
            return treeNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

