/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.pm.calendar;

import com.projectlibre.pm.calendar.CalendarId;
import com.projectlibre.pm.calendar.DuplicateCalendarException;
import com.projectlibre.pm.calendar.WorkCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CalendarManager
implements Iterable<WorkCalendar> {
    protected WorkCalendar standardBaseCalendar;
    protected Map<CalendarId, WorkCalendar> baseCalendarsById = new HashMap<CalendarId, WorkCalendar>();
    protected Map<String, WorkCalendar> baseCalendarsByName = new HashMap<String, WorkCalendar>();

    public WorkCalendar addBaseCalendar(WorkCalendar workCalendar) throws DuplicateCalendarException {
        if (this.baseCalendarsById.containsKey(workCalendar.getId())) {
            throw new DuplicateCalendarException("Calendar id " + workCalendar.getName() + " already exists");
        }
        if (workCalendar.getName() == null || this.baseCalendarsByName.containsKey(workCalendar.getName())) {
            throw new DuplicateCalendarException("Calendar name " + workCalendar.getName() + " already exists");
        }
        this.baseCalendarsById.put(workCalendar.getId(), workCalendar);
        this.baseCalendarsByName.put(workCalendar.getName(), workCalendar);
        return workCalendar;
    }

    @Override
    public Iterator<WorkCalendar> iterator() {
        return this.baseCalendarsById.values().iterator();
    }

    public WorkCalendar removeBaseCalendar(WorkCalendar workCalendar) {
        WorkCalendar workCalendar2 = this.baseCalendarsById.remove(workCalendar.getId());
        this.baseCalendarsByName.remove(workCalendar.getName());
        return workCalendar2;
    }

    public void fixBaseCalendar(WorkCalendar workCalendar, String string) {
        String string2 = workCalendar.getName();
        if (string2 == null || this.baseCalendarsByName.containsKey(string2)) {
            workCalendar.setName(string2 + " [" + string + "]");
        }
    }

    public WorkCalendar getStandardBaseCalendar() {
        return this.standardBaseCalendar;
    }

    public void setStandardBaseCalendar(WorkCalendar workCalendar) {
        this.standardBaseCalendar = workCalendar;
    }

    public WorkCalendar getCalendar(CalendarId calendarId) {
        return this.baseCalendarsById.get(calendarId);
    }

    public WorkCalendar getCalendar(String string) {
        return this.baseCalendarsByName.get(string);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("CalendarManager #").append(this.hashCode()).append('\n');
        if (this.standardBaseCalendar == null) {
            stringBuffer.append(string).append("\t").append("standardBaseCalendar=null").append('\n');
        } else {
            stringBuffer.append(string).append("\t").append("standardBaseCalendar=").append(this.standardBaseCalendar).append('\n');
        }
        stringBuffer.append(string).append("\t").append("baseCalendarsById=\n");
        for (CalendarId object : this.baseCalendarsById.keySet()) {
            stringBuffer.append(string).append("\t\tcalendarId=").append(object).append('\n');
            WorkCalendar workCalendar = this.baseCalendarsById.get(object);
            stringBuffer.append(workCalendar.toLongString(string + "\t\t")).append('\n');
        }
        stringBuffer.append(string).append("\t").append("baseCalendarsByName=\n");
        for (String string2 : this.baseCalendarsByName.keySet()) {
            stringBuffer.append(string).append("\t\tcalendarName=").append(string2).append('\n');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

