"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FieldMappingService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getMappingsView", async (_context, request, response) => {
      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const {
          indexName,
          ruleTopic
        } = request.query;
        const params = {
          indexName,
          ruleTopic
        };
        const getFieldMappingViewResponse = await callWithRequest(_constants.CLIENT_FIELD_MAPPINGS_METHODS.GET_MAPPINGS_VIEW, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFieldMappingViewResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FieldMappingService - getMappingsView:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "createMappings", async (_context, request, response) => {
      try {
        const params = {
          body: request.body
        };
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getDetectorResponse = await callWithRequest(_constants.CLIENT_FIELD_MAPPINGS_METHODS.CREATE_MAPPINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getDetectorResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - getDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    _defineProperty(this, "getMappings", async (_context, request, response) => {
      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const {
          indexName
        } = request.query;
        const params = {
          indexName
        };
        const getFieldMappingsResponse = await callWithRequest(_constants.CLIENT_FIELD_MAPPINGS_METHODS.GET_MAPPINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFieldMappingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FieldMappingService - getMappings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET mappings/view API.
   */


}

exports.default = FieldMappingService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkZpZWxkTWFwcGluZ1NlcnZpY2UudHMiXSwibmFtZXMiOlsiRmllbGRNYXBwaW5nU2VydmljZSIsImNvbnN0cnVjdG9yIiwib3NEcml2ZXIiLCJfY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsImNhbGxBc0N1cnJlbnRVc2VyIiwiY2FsbFdpdGhSZXF1ZXN0IiwiYXNTY29wZWQiLCJpbmRleE5hbWUiLCJydWxlVG9waWMiLCJxdWVyeSIsInBhcmFtcyIsImdldEZpZWxkTWFwcGluZ1ZpZXdSZXNwb25zZSIsIkNMSUVOVF9GSUVMRF9NQVBQSU5HU19NRVRIT0RTIiwiR0VUX01BUFBJTkdTX1ZJRVciLCJjdXN0b20iLCJzdGF0dXNDb2RlIiwiYm9keSIsIm9rIiwiZXJyb3IiLCJjb25zb2xlIiwibWVzc2FnZSIsImdldERldGVjdG9yUmVzcG9uc2UiLCJDUkVBVEVfTUFQUElOR1MiLCJnZXRGaWVsZE1hcHBpbmdzUmVzcG9uc2UiLCJHRVRfTUFQUElOR1MiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUF1QkE7Ozs7QUFFZSxNQUFNQSxtQkFBTixDQUEwQjtBQUd2Q0MsRUFBQUEsV0FBVyxDQUFDQyxRQUFELEVBQXVDO0FBQUE7O0FBQUEsNkNBT2hDLE9BQ2hCQyxRQURnQixFQUVoQkMsT0FGZ0IsRUFHaEJDLFFBSGdCLEtBTWI7QUFDSCxVQUFJO0FBQ0YsY0FBTTtBQUFFQyxVQUFBQSxpQkFBaUIsRUFBRUM7QUFBckIsWUFBeUMsS0FBS0wsUUFBTCxDQUFjTSxRQUFkLENBQXVCSixPQUF2QixDQUEvQztBQUNBLGNBQU07QUFBRUssVUFBQUEsU0FBRjtBQUFhQyxVQUFBQTtBQUFiLFlBQTJCTixPQUFPLENBQUNPLEtBQXpDO0FBQ0EsY0FBTUMsTUFBaUMsR0FBRztBQUN4Q0gsVUFBQUEsU0FEd0M7QUFFeENDLFVBQUFBO0FBRndDLFNBQTFDO0FBSUEsY0FBTUcsMkJBQTJCLEdBQUcsTUFBTU4sZUFBZSxDQUN2RE8seUNBQThCQyxpQkFEeUIsRUFFdkRILE1BRnVELENBQXpEO0FBS0EsZUFBT1AsUUFBUSxDQUFDVyxNQUFULENBQWdCO0FBQ3JCQyxVQUFBQSxVQUFVLEVBQUUsR0FEUztBQUVyQkMsVUFBQUEsSUFBSSxFQUFFO0FBQ0pDLFlBQUFBLEVBQUUsRUFBRSxJQURBO0FBRUpkLFlBQUFBLFFBQVEsRUFBRVE7QUFGTjtBQUZlLFNBQWhCLENBQVA7QUFPRCxPQW5CRCxDQW1CRSxPQUFPTyxLQUFQLEVBQW1CO0FBQ25CQyxRQUFBQSxPQUFPLENBQUNELEtBQVIsQ0FBYyw2REFBZCxFQUE2RUEsS0FBN0U7QUFDQSxlQUFPZixRQUFRLENBQUNXLE1BQVQsQ0FBZ0I7QUFDckJDLFVBQUFBLFVBQVUsRUFBRSxHQURTO0FBRXJCQyxVQUFBQSxJQUFJLEVBQUU7QUFDSkMsWUFBQUEsRUFBRSxFQUFFLEtBREE7QUFFSkMsWUFBQUEsS0FBSyxFQUFFQSxLQUFLLENBQUNFO0FBRlQ7QUFGZSxTQUFoQixDQUFQO0FBT0Q7QUFDRixLQTNDaUQ7O0FBQUEsNENBZ0RqQyxPQUNmbkIsUUFEZSxFQUVmQyxPQUZlLEVBR2ZDLFFBSGUsS0FNWjtBQUNILFVBQUk7QUFDRixjQUFNTyxNQUE0QixHQUFHO0FBQUVNLFVBQUFBLElBQUksRUFBRWQsT0FBTyxDQUFDYztBQUFoQixTQUFyQztBQUNBLGNBQU07QUFBRVosVUFBQUEsaUJBQWlCLEVBQUVDO0FBQXJCLFlBQXlDLEtBQUtMLFFBQUwsQ0FBY00sUUFBZCxDQUF1QkosT0FBdkIsQ0FBL0M7QUFDQSxjQUFNbUIsbUJBQTJDLEdBQUcsTUFBTWhCLGVBQWUsQ0FDdkVPLHlDQUE4QlUsZUFEeUMsRUFFdkVaLE1BRnVFLENBQXpFO0FBS0EsZUFBT1AsUUFBUSxDQUFDVyxNQUFULENBQWdCO0FBQ3JCQyxVQUFBQSxVQUFVLEVBQUUsR0FEUztBQUVyQkMsVUFBQUEsSUFBSSxFQUFFO0FBQ0pDLFlBQUFBLEVBQUUsRUFBRSxJQURBO0FBRUpkLFlBQUFBLFFBQVEsRUFBRWtCO0FBRk47QUFGZSxTQUFoQixDQUFQO0FBT0QsT0FmRCxDQWVFLE9BQU9ILEtBQVAsRUFBbUI7QUFDbkJDLFFBQUFBLE9BQU8sQ0FBQ0QsS0FBUixDQUFjLHNEQUFkLEVBQXNFQSxLQUF0RTtBQUNBLGVBQU9mLFFBQVEsQ0FBQ1csTUFBVCxDQUFnQjtBQUNyQkMsVUFBQUEsVUFBVSxFQUFFLEdBRFM7QUFFckJDLFVBQUFBLElBQUksRUFBRTtBQUNKQyxZQUFBQSxFQUFFLEVBQUUsS0FEQTtBQUVKQyxZQUFBQSxLQUFLLEVBQUVBLEtBQUssQ0FBQ0U7QUFGVDtBQUZlLFNBQWhCLENBQVA7QUFPRDtBQUNGLEtBaEZpRDs7QUFBQSx5Q0FxRnBDLE9BQ1puQixRQURZLEVBRVpDLE9BRlksRUFHWkMsUUFIWSxLQU1UO0FBQ0gsVUFBSTtBQUNGLGNBQU07QUFBRUMsVUFBQUEsaUJBQWlCLEVBQUVDO0FBQXJCLFlBQXlDLEtBQUtMLFFBQUwsQ0FBY00sUUFBZCxDQUF1QkosT0FBdkIsQ0FBL0M7QUFDQSxjQUFNO0FBQUVLLFVBQUFBO0FBQUYsWUFBZ0JMLE9BQU8sQ0FBQ08sS0FBOUI7QUFDQSxjQUFNQyxNQUF5QixHQUFHO0FBQ2hDSCxVQUFBQTtBQURnQyxTQUFsQztBQUdBLGNBQU1nQix3QkFBd0IsR0FBRyxNQUFNbEIsZUFBZSxDQUNwRE8seUNBQThCWSxZQURzQixFQUVwRGQsTUFGb0QsQ0FBdEQ7QUFLQSxlQUFPUCxRQUFRLENBQUNXLE1BQVQsQ0FBZ0I7QUFDckJDLFVBQUFBLFVBQVUsRUFBRSxHQURTO0FBRXJCQyxVQUFBQSxJQUFJLEVBQUU7QUFDSkMsWUFBQUEsRUFBRSxFQUFFLElBREE7QUFFSmQsWUFBQUEsUUFBUSxFQUFFb0I7QUFGTjtBQUZlLFNBQWhCLENBQVA7QUFPRCxPQWxCRCxDQWtCRSxPQUFPTCxLQUFQLEVBQW1CO0FBQ25CQyxRQUFBQSxPQUFPLENBQUNELEtBQVIsQ0FBYyx5REFBZCxFQUF5RUEsS0FBekU7QUFDQSxlQUFPZixRQUFRLENBQUNXLE1BQVQsQ0FBZ0I7QUFDckJDLFVBQUFBLFVBQVUsRUFBRSxHQURTO0FBRXJCQyxVQUFBQSxJQUFJLEVBQUU7QUFDSkMsWUFBQUEsRUFBRSxFQUFFLEtBREE7QUFFSkMsWUFBQUEsS0FBSyxFQUFFQSxLQUFLLENBQUNFO0FBRlQ7QUFGZSxTQUFoQixDQUFQO0FBT0Q7QUFDRixLQXhIaUQ7O0FBQ2hELFNBQUtwQixRQUFMLEdBQWdCQSxRQUFoQjtBQUNEO0FBRUQ7QUFDRjtBQUNBOzs7QUFUeUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXG4gIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlLFxuICBSZXNwb25zZUVycm9yLFxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gIElMZWdhY3lDdXN0b21DbHVzdGVyQ2xpZW50LFxufSBmcm9tICdvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyJztcbmltcG9ydCB7XG4gIENyZWF0ZU1hcHBpbmdCb2R5LFxuICBDcmVhdGVNYXBwaW5nc1BhcmFtcyxcbiAgQ3JlYXRlTWFwcGluZ3NSZXNwb25zZSxcbiAgR2V0RmllbGRNYXBpbmdzVmlld1BhcmFtcyxcbiAgR2V0RmllbGRNYXBwaW5nVmlld1Jlc3BvbnNlLFxuICBHZXRNYXBwaW5nc1BhcmFtcyxcbiAgR2V0TWFwcGluZ3NSZXNwb25zZSxcbn0gZnJvbSAnLi4vbW9kZWxzL2ludGVyZmFjZXMnO1xuaW1wb3J0IHsgU2VydmVyUmVzcG9uc2UgfSBmcm9tICcuLi9tb2RlbHMvdHlwZXMnO1xuaW1wb3J0IHsgQ0xJRU5UX0ZJRUxEX01BUFBJTkdTX01FVEhPRFMgfSBmcm9tICcuLi91dGlscy9jb25zdGFudHMnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBGaWVsZE1hcHBpbmdTZXJ2aWNlIHtcbiAgb3NEcml2ZXI6IElMZWdhY3lDdXN0b21DbHVzdGVyQ2xpZW50O1xuXG4gIGNvbnN0cnVjdG9yKG9zRHJpdmVyOiBJTGVnYWN5Q3VzdG9tQ2x1c3RlckNsaWVudCkge1xuICAgIHRoaXMub3NEcml2ZXIgPSBvc0RyaXZlcjtcbiAgfVxuXG4gIC8qKlxuICAgKiBDYWxscyBiYWNrZW5kIEdFVCBtYXBwaW5ncy92aWV3IEFQSS5cbiAgICovXG4gIGdldE1hcHBpbmdzVmlldyA9IGFzeW5jIChcbiAgICBfY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxcbiAgICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxHZXRGaWVsZE1hcHBpbmdWaWV3UmVzcG9uc2U+IHwgUmVzcG9uc2VFcnJvcj5cbiAgPiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgY2FsbEFzQ3VycmVudFVzZXI6IGNhbGxXaXRoUmVxdWVzdCB9ID0gdGhpcy5vc0RyaXZlci5hc1Njb3BlZChyZXF1ZXN0KTtcbiAgICAgIGNvbnN0IHsgaW5kZXhOYW1lLCBydWxlVG9waWMgfSA9IHJlcXVlc3QucXVlcnkgYXMgeyBpbmRleE5hbWU6IHN0cmluZzsgcnVsZVRvcGljPzogc3RyaW5nIH07XG4gICAgICBjb25zdCBwYXJhbXM6IEdldEZpZWxkTWFwaW5nc1ZpZXdQYXJhbXMgPSB7XG4gICAgICAgIGluZGV4TmFtZSxcbiAgICAgICAgcnVsZVRvcGljLFxuICAgICAgfTtcbiAgICAgIGNvbnN0IGdldEZpZWxkTWFwcGluZ1ZpZXdSZXNwb25zZSA9IGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcbiAgICAgICAgQ0xJRU5UX0ZJRUxEX01BUFBJTkdTX01FVEhPRFMuR0VUX01BUFBJTkdTX1ZJRVcsXG4gICAgICAgIHBhcmFtc1xuICAgICAgKTtcblxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3BvbnNlOiBnZXRGaWVsZE1hcHBpbmdWaWV3UmVzcG9uc2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnJvcjogYW55KSB7XG4gICAgICBjb25zb2xlLmVycm9yKCdTZWN1cml0eSBBbmFseXRpY3MgLSBGaWVsZE1hcHBpbmdTZXJ2aWNlIC0gZ2V0TWFwcGluZ3NWaWV3OicsIGVycm9yKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVycm9yLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgLyoqXG4gICAqIENhbGxzIGJhY2tlbmQgR0VUIERldGVjdG9yIEFQSS5cbiAgICovXG4gIGNyZWF0ZU1hcHBpbmdzID0gYXN5bmMgKFxuICAgIF9jb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPFxuICAgIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPENyZWF0ZU1hcHBpbmdzUmVzcG9uc2U+IHwgUmVzcG9uc2VFcnJvcj5cbiAgPiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHBhcmFtczogQ3JlYXRlTWFwcGluZ3NQYXJhbXMgPSB7IGJvZHk6IHJlcXVlc3QuYm9keSBhcyBDcmVhdGVNYXBwaW5nQm9keSB9O1xuICAgICAgY29uc3QgeyBjYWxsQXNDdXJyZW50VXNlcjogY2FsbFdpdGhSZXF1ZXN0IH0gPSB0aGlzLm9zRHJpdmVyLmFzU2NvcGVkKHJlcXVlc3QpO1xuICAgICAgY29uc3QgZ2V0RGV0ZWN0b3JSZXNwb25zZTogQ3JlYXRlTWFwcGluZ3NSZXNwb25zZSA9IGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcbiAgICAgICAgQ0xJRU5UX0ZJRUxEX01BUFBJTkdTX01FVEhPRFMuQ1JFQVRFX01BUFBJTkdTLFxuICAgICAgICBwYXJhbXNcbiAgICAgICk7XG5cbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZTogZ2V0RGV0ZWN0b3JSZXNwb25zZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIERldGVjdG9yc1NlcnZpY2UgLSBnZXREZXRlY3RvcjonLCBlcnJvcik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xuXG4gIC8qKlxuICAgKiBDYWxscyBiYWNrZW5kIEdFVCBtYXBwaW5ncy92aWV3IEFQSS5cbiAgICovXG4gIGdldE1hcHBpbmdzID0gYXN5bmMgKFxuICAgIF9jb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPFxuICAgIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPEdldE1hcHBpbmdzUmVzcG9uc2U+IHwgUmVzcG9uc2VFcnJvcj5cbiAgPiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgY2FsbEFzQ3VycmVudFVzZXI6IGNhbGxXaXRoUmVxdWVzdCB9ID0gdGhpcy5vc0RyaXZlci5hc1Njb3BlZChyZXF1ZXN0KTtcbiAgICAgIGNvbnN0IHsgaW5kZXhOYW1lIH0gPSByZXF1ZXN0LnF1ZXJ5IGFzIHsgaW5kZXhOYW1lOiBzdHJpbmcgfTtcbiAgICAgIGNvbnN0IHBhcmFtczogR2V0TWFwcGluZ3NQYXJhbXMgPSB7XG4gICAgICAgIGluZGV4TmFtZSxcbiAgICAgIH07XG4gICAgICBjb25zdCBnZXRGaWVsZE1hcHBpbmdzUmVzcG9uc2UgPSBhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXG4gICAgICAgIENMSUVOVF9GSUVMRF9NQVBQSU5HU19NRVRIT0RTLkdFVF9NQVBQSU5HUyxcbiAgICAgICAgcGFyYW1zXG4gICAgICApO1xuXG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IGdldEZpZWxkTWFwcGluZ3NSZXNwb25zZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ1NlY3VyaXR5IEFuYWx5dGljcyAtIEZpZWxkTWFwcGluZ1NlcnZpY2UgLSBnZXRNYXBwaW5nczonLCBlcnJvcik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnJvci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xufVxuIl19