"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceBlockedKeywords = exports.WINDOW = exports.TRIGGER_TYPE = exports.SECURITY_CONSTANTS = exports.SCHEDULE_TYPE = exports.REPORT_TYPE = exports.REPORT_STATE = exports.REPORT_DEFINITION_STATUS = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.FORMAT = exports.EXTRA_HEADERS = exports.DELIVERY_TYPE = exports.DELIVERY_CHANNEL = exports.DEFAULT_ROLLING_COUNTER = exports.DEFAULT_MAX_SIZE = exports.DATA_REPORT_CONFIG = exports.CAPACITY = exports.ALLOWED_HOSTS = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let FORMAT;
exports.FORMAT = FORMAT;

(function (FORMAT) {
  FORMAT["pdf"] = "pdf";
  FORMAT["png"] = "png";
  FORMAT["csv"] = "csv";
})(FORMAT || (exports.FORMAT = FORMAT = {}));

let REPORT_STATE;
exports.REPORT_STATE = REPORT_STATE;

(function (REPORT_STATE) {
  REPORT_STATE["created"] = "Created";
  REPORT_STATE["error"] = "Error";
  REPORT_STATE["pending"] = "Pending";
  REPORT_STATE["shared"] = "Shared";
})(REPORT_STATE || (exports.REPORT_STATE = REPORT_STATE = {}));

let REPORT_DEFINITION_STATUS;
exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS;

(function (REPORT_DEFINITION_STATUS) {
  REPORT_DEFINITION_STATUS["active"] = "Active";
  REPORT_DEFINITION_STATUS["disabled"] = "Disabled";
})(REPORT_DEFINITION_STATUS || (exports.REPORT_DEFINITION_STATUS = REPORT_DEFINITION_STATUS = {}));

let DELIVERY_CHANNEL;
exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL;

(function (DELIVERY_CHANNEL) {
  DELIVERY_CHANNEL["email"] = "Email";
  DELIVERY_CHANNEL["slack"] = "Slack";
  DELIVERY_CHANNEL["chime"] = "Chime";
  DELIVERY_CHANNEL["opensearchDashboards"] = "OpenSearch Dashboards user";
})(DELIVERY_CHANNEL || (exports.DELIVERY_CHANNEL = DELIVERY_CHANNEL = {}));

let SCHEDULE_TYPE;
exports.SCHEDULE_TYPE = SCHEDULE_TYPE;

(function (SCHEDULE_TYPE) {
  SCHEDULE_TYPE["recurring"] = "Recurring";
  SCHEDULE_TYPE["cron"] = "Cron based";
})(SCHEDULE_TYPE || (exports.SCHEDULE_TYPE = SCHEDULE_TYPE = {}));

let REPORT_TYPE;
exports.REPORT_TYPE = REPORT_TYPE;

(function (REPORT_TYPE) {
  REPORT_TYPE["savedSearch"] = "Saved search";
  REPORT_TYPE["dashboard"] = "Dashboard";
  REPORT_TYPE["visualization"] = "Visualization";
  REPORT_TYPE["notebook"] = "Notebook";
})(REPORT_TYPE || (exports.REPORT_TYPE = REPORT_TYPE = {}));

let DATA_REPORT_CONFIG;
exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG;

(function (DATA_REPORT_CONFIG) {
  DATA_REPORT_CONFIG["excelDateFormat"] = "MM/DD/YYYY h:mm:ss.SSS a";
})(DATA_REPORT_CONFIG || (exports.DATA_REPORT_CONFIG = DATA_REPORT_CONFIG = {}));

let TRIGGER_TYPE;
exports.TRIGGER_TYPE = TRIGGER_TYPE;

(function (TRIGGER_TYPE) {
  TRIGGER_TYPE["schedule"] = "Schedule";
  TRIGGER_TYPE["onDemand"] = "On demand";
})(TRIGGER_TYPE || (exports.TRIGGER_TYPE = TRIGGER_TYPE = {}));

let DELIVERY_TYPE; // https://www.elastic.co/guide/en/elasticsearch/reference/6.8/search-request-from-size.html

exports.DELIVERY_TYPE = DELIVERY_TYPE;

(function (DELIVERY_TYPE) {
  DELIVERY_TYPE["opensearchDashboardsUser"] = "OpenSearch Dashboards user";
  DELIVERY_TYPE["channel"] = "Channel";
})(DELIVERY_TYPE || (exports.DELIVERY_TYPE = DELIVERY_TYPE = {}));

const DEFAULT_MAX_SIZE = 10000;
exports.DEFAULT_MAX_SIZE = DEFAULT_MAX_SIZE;
const SECURITY_CONSTANTS = {
  TENANT_LOCAL_STORAGE_KEY: 'opendistro::security::tenant::show_popup'
};
exports.SECURITY_CONSTANTS = SECURITY_CONSTANTS;
const EXTRA_HEADERS = ['cookie', 'x-proxy-user', 'x-proxy-roles', 'x-forwarded-for'];
exports.EXTRA_HEADERS = EXTRA_HEADERS;
const BLOCKED_KEYWORD = 'BLOCKED_KEYWORD';
const ipv4Regex = /(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?):([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const ipv6Regex = /(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))/g;
const localhostRegex = /localhost:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const iframeRegex = /iframe/g;
const ALLOWED_HOSTS = /^(0|0.0.0.0|127.0.0.1|localhost|(.*\.)?(opensearch.org|aws.a2z.com))$/;
exports.ALLOWED_HOSTS = ALLOWED_HOSTS;

const replaceBlockedKeywords = htmlString => {
  // replace <ipv4>:<port>
  htmlString = htmlString.replace(ipv4Regex, BLOCKED_KEYWORD); // replace ipv6 addresses

  htmlString = htmlString.replace(ipv6Regex, BLOCKED_KEYWORD); // replace iframe keyword

  htmlString = htmlString.replace(iframeRegex, BLOCKED_KEYWORD); // replace localhost:<port>

  htmlString = htmlString.replace(localhostRegex, BLOCKED_KEYWORD);
  return htmlString;
};
/**
 * Metric constants
 */


exports.replaceBlockedKeywords = replaceBlockedKeywords;
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const GLOBAL_BASIC_COUNTER = {
  report: {
    create: {
      total: 0
    },
    create_from_definition: {
      total: 0
    },
    download: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    }
  },
  report_definition: {
    create: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    },
    update: {
      total: 0
    },
    delete: {
      total: 0
    }
  },
  report_source: {
    list: {
      total: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        total: 0
      }
    }
  }
};
exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;
const DEFAULT_ROLLING_COUNTER = {
  report: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    create_from_definition: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    download: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_definition: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    update: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    delete: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_source: {
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        count: 0
      }
    }
  }
};
exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbnN0YW50cy50cyJdLCJuYW1lcyI6WyJGT1JNQVQiLCJSRVBPUlRfU1RBVEUiLCJSRVBPUlRfREVGSU5JVElPTl9TVEFUVVMiLCJERUxJVkVSWV9DSEFOTkVMIiwiU0NIRURVTEVfVFlQRSIsIlJFUE9SVF9UWVBFIiwiREFUQV9SRVBPUlRfQ09ORklHIiwiVFJJR0dFUl9UWVBFIiwiREVMSVZFUllfVFlQRSIsIkRFRkFVTFRfTUFYX1NJWkUiLCJTRUNVUklUWV9DT05TVEFOVFMiLCJURU5BTlRfTE9DQUxfU1RPUkFHRV9LRVkiLCJFWFRSQV9IRUFERVJTIiwiQkxPQ0tFRF9LRVlXT1JEIiwiaXB2NFJlZ2V4IiwiaXB2NlJlZ2V4IiwibG9jYWxob3N0UmVnZXgiLCJpZnJhbWVSZWdleCIsIkFMTE9XRURfSE9TVFMiLCJyZXBsYWNlQmxvY2tlZEtleXdvcmRzIiwiaHRtbFN0cmluZyIsInJlcGxhY2UiLCJXSU5ET1ciLCJJTlRFUlZBTCIsIkNBUEFDSVRZIiwiR0xPQkFMX0JBU0lDX0NPVU5URVIiLCJyZXBvcnQiLCJjcmVhdGUiLCJ0b3RhbCIsImNyZWF0ZV9mcm9tX2RlZmluaXRpb24iLCJkb3dubG9hZCIsImxpc3QiLCJpbmZvIiwicmVwb3J0X2RlZmluaXRpb24iLCJ1cGRhdGUiLCJkZWxldGUiLCJyZXBvcnRfc291cmNlIiwiZGFzaGJvYXJkIiwicGRmIiwicG5nIiwidmlzdWFsaXphdGlvbiIsIm5vdGVib29rIiwiY291bnQiLCJzYXZlZF9zZWFyY2giLCJjc3YiLCJERUZBVUxUX1JPTExJTkdfQ09VTlRFUiIsInN5c3RlbV9lcnJvciIsInVzZXJfZXJyb3IiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtJQUtZQSxNOzs7V0FBQUEsTTtBQUFBQSxFQUFBQSxNO0FBQUFBLEVBQUFBLE07QUFBQUEsRUFBQUEsTTtHQUFBQSxNLHNCQUFBQSxNOztJQU1BQyxZOzs7V0FBQUEsWTtBQUFBQSxFQUFBQSxZO0FBQUFBLEVBQUFBLFk7QUFBQUEsRUFBQUEsWTtBQUFBQSxFQUFBQSxZO0dBQUFBLFksNEJBQUFBLFk7O0lBT0FDLHdCOzs7V0FBQUEsd0I7QUFBQUEsRUFBQUEsd0I7QUFBQUEsRUFBQUEsd0I7R0FBQUEsd0Isd0NBQUFBLHdCOztJQUtBQyxnQjs7O1dBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0FBQUFBLEVBQUFBLGdCO0dBQUFBLGdCLGdDQUFBQSxnQjs7SUFPQUMsYTs7O1dBQUFBLGE7QUFBQUEsRUFBQUEsYTtBQUFBQSxFQUFBQSxhO0dBQUFBLGEsNkJBQUFBLGE7O0lBS0FDLFc7OztXQUFBQSxXO0FBQUFBLEVBQUFBLFc7QUFBQUEsRUFBQUEsVztBQUFBQSxFQUFBQSxXO0FBQUFBLEVBQUFBLFc7R0FBQUEsVywyQkFBQUEsVzs7SUFPQUMsa0I7OztXQUFBQSxrQjtBQUFBQSxFQUFBQSxrQjtHQUFBQSxrQixrQ0FBQUEsa0I7O0lBSUFDLFk7OztXQUFBQSxZO0FBQUFBLEVBQUFBLFk7QUFBQUEsRUFBQUEsWTtHQUFBQSxZLDRCQUFBQSxZOztJQUtBQyxhLEVBS1o7Ozs7V0FMWUEsYTtBQUFBQSxFQUFBQSxhO0FBQUFBLEVBQUFBLGE7R0FBQUEsYSw2QkFBQUEsYTs7QUFNTCxNQUFNQyxnQkFBZ0IsR0FBRyxLQUF6Qjs7QUFFQSxNQUFNQyxrQkFBa0IsR0FBRztBQUNoQ0MsRUFBQUEsd0JBQXdCLEVBQUU7QUFETSxDQUEzQjs7QUFJQSxNQUFNQyxhQUFhLEdBQUcsQ0FDM0IsUUFEMkIsRUFFM0IsY0FGMkIsRUFHM0IsZUFIMkIsRUFJM0IsaUJBSjJCLENBQXRCOztBQU9QLE1BQU1DLGVBQWUsR0FBRyxpQkFBeEI7QUFDQSxNQUFNQyxTQUFTLEdBQUcsd1BBQWxCO0FBQ0EsTUFBTUMsU0FBUyxHQUFHLHNwQkFBbEI7QUFDQSxNQUFNQyxjQUFjLEdBQUcsbUdBQXZCO0FBQ0EsTUFBTUMsV0FBVyxHQUFHLFNBQXBCO0FBRU8sTUFBTUMsYUFBYSxHQUFHLHVFQUF0Qjs7O0FBRUEsTUFBTUMsc0JBQXNCLEdBQUlDLFVBQUQsSUFBd0I7QUFDNUQ7QUFDQUEsRUFBQUEsVUFBVSxHQUFHQSxVQUFVLENBQUNDLE9BQVgsQ0FBbUJQLFNBQW5CLEVBQThCRCxlQUE5QixDQUFiLENBRjRELENBRzVEOztBQUNBTyxFQUFBQSxVQUFVLEdBQUdBLFVBQVUsQ0FBQ0MsT0FBWCxDQUFtQk4sU0FBbkIsRUFBOEJGLGVBQTlCLENBQWIsQ0FKNEQsQ0FLNUQ7O0FBQ0FPLEVBQUFBLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFYLENBQW1CSixXQUFuQixFQUFnQ0osZUFBaEMsQ0FBYixDQU40RCxDQU81RDs7QUFDQU8sRUFBQUEsVUFBVSxHQUFHQSxVQUFVLENBQUNDLE9BQVgsQ0FBbUJMLGNBQW5CLEVBQW1DSCxlQUFuQyxDQUFiO0FBQ0EsU0FBT08sVUFBUDtBQUNELENBVk07QUFhUDtBQUNBO0FBQ0E7Ozs7QUFDTyxNQUFNRSxNQUFNLEdBQUcsSUFBZjs7QUFDQSxNQUFNQyxRQUFRLEdBQUcsRUFBakI7O0FBQ0EsTUFBTUMsUUFBUSxHQUFJRixNQUFNLEdBQUdDLFFBQVYsR0FBc0IsQ0FBdkM7O0FBRUEsTUFBTUUsb0JBQWtDLEdBQUc7QUFDaERDLEVBQUFBLE1BQU0sRUFBRTtBQUNOQyxJQUFBQSxNQUFNLEVBQUU7QUFDTkMsTUFBQUEsS0FBSyxFQUFFO0FBREQsS0FERjtBQUlOQyxJQUFBQSxzQkFBc0IsRUFBRTtBQUN0QkQsTUFBQUEsS0FBSyxFQUFFO0FBRGUsS0FKbEI7QUFPTkUsSUFBQUEsUUFBUSxFQUFFO0FBQ1JGLE1BQUFBLEtBQUssRUFBRTtBQURDLEtBUEo7QUFVTkcsSUFBQUEsSUFBSSxFQUFFO0FBQ0pILE1BQUFBLEtBQUssRUFBRTtBQURILEtBVkE7QUFhTkksSUFBQUEsSUFBSSxFQUFFO0FBQ0pKLE1BQUFBLEtBQUssRUFBRTtBQURIO0FBYkEsR0FEd0M7QUFrQmhESyxFQUFBQSxpQkFBaUIsRUFBRTtBQUNqQk4sSUFBQUEsTUFBTSxFQUFFO0FBQ05DLE1BQUFBLEtBQUssRUFBRTtBQURELEtBRFM7QUFJakJHLElBQUFBLElBQUksRUFBRTtBQUNKSCxNQUFBQSxLQUFLLEVBQUU7QUFESCxLQUpXO0FBT2pCSSxJQUFBQSxJQUFJLEVBQUU7QUFDSkosTUFBQUEsS0FBSyxFQUFFO0FBREgsS0FQVztBQVVqQk0sSUFBQUEsTUFBTSxFQUFFO0FBQ05OLE1BQUFBLEtBQUssRUFBRTtBQURELEtBVlM7QUFhakJPLElBQUFBLE1BQU0sRUFBRTtBQUNOUCxNQUFBQSxLQUFLLEVBQUU7QUFERDtBQWJTLEdBbEI2QjtBQW1DaERRLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSkgsTUFBQUEsS0FBSyxFQUFFO0FBREg7QUFETyxHQW5DaUM7QUF3Q2hEUyxFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVFcsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0F4Q3FDO0FBb0RoRFksRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJXLElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUkYsUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBcERpQztBQWdFaERhLEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQWhFc0M7QUE0RWhEQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSRixRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUE1RWtDLENBQTNDOztBQXFGQSxNQUFNaUIsdUJBQXFDLEdBQUc7QUFDbkRuQixFQUFBQSxNQUFNLEVBQUU7QUFDTkMsSUFBQUEsTUFBTSxFQUFFO0FBQ05lLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBREY7QUFNTmxCLElBQUFBLHNCQUFzQixFQUFFO0FBQ3RCYSxNQUFBQSxLQUFLLEVBQUUsQ0FEZTtBQUV0QkksTUFBQUEsWUFBWSxFQUFFLENBRlE7QUFHdEJDLE1BQUFBLFVBQVUsRUFBRTtBQUhVLEtBTmxCO0FBV05qQixJQUFBQSxRQUFRLEVBQUU7QUFDUlksTUFBQUEsS0FBSyxFQUFFLENBREM7QUFFUkksTUFBQUEsWUFBWSxFQUFFLENBRk47QUFHUkMsTUFBQUEsVUFBVSxFQUFFO0FBSEosS0FYSjtBQWdCTmhCLElBQUFBLElBQUksRUFBRTtBQUNKVyxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQWhCQTtBQXFCTmYsSUFBQUEsSUFBSSxFQUFFO0FBQ0pVLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSO0FBckJBLEdBRDJDO0FBNEJuRGQsRUFBQUEsaUJBQWlCLEVBQUU7QUFDakJOLElBQUFBLE1BQU0sRUFBRTtBQUNOZSxNQUFBQSxLQUFLLEVBQUUsQ0FERDtBQUVOSSxNQUFBQSxZQUFZLEVBQUUsQ0FGUjtBQUdOQyxNQUFBQSxVQUFVLEVBQUU7QUFITixLQURTO0FBTWpCaEIsSUFBQUEsSUFBSSxFQUFFO0FBQ0pXLE1BQUFBLEtBQUssRUFBRSxDQURIO0FBRUpJLE1BQUFBLFlBQVksRUFBRSxDQUZWO0FBR0pDLE1BQUFBLFVBQVUsRUFBRTtBQUhSLEtBTlc7QUFXakJmLElBQUFBLElBQUksRUFBRTtBQUNKVSxNQUFBQSxLQUFLLEVBQUUsQ0FESDtBQUVKSSxNQUFBQSxZQUFZLEVBQUUsQ0FGVjtBQUdKQyxNQUFBQSxVQUFVLEVBQUU7QUFIUixLQVhXO0FBZ0JqQmIsSUFBQUEsTUFBTSxFQUFFO0FBQ05RLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOLEtBaEJTO0FBcUJqQlosSUFBQUEsTUFBTSxFQUFFO0FBQ05PLE1BQUFBLEtBQUssRUFBRSxDQUREO0FBRU5JLE1BQUFBLFlBQVksRUFBRSxDQUZSO0FBR05DLE1BQUFBLFVBQVUsRUFBRTtBQUhOO0FBckJTLEdBNUJnQztBQXVEbkRYLEVBQUFBLGFBQWEsRUFBRTtBQUNiTCxJQUFBQSxJQUFJLEVBQUU7QUFDSlcsTUFBQUEsS0FBSyxFQUFFLENBREg7QUFFSkksTUFBQUEsWUFBWSxFQUFFLENBRlY7QUFHSkMsTUFBQUEsVUFBVSxFQUFFO0FBSFI7QUFETyxHQXZEb0M7QUE4RG5EVixFQUFBQSxTQUFTLEVBQUU7QUFDVEMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hSLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQLEtBREk7QUFNVEgsSUFBQUEsR0FBRyxFQUFFO0FBQ0hULE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBTkksR0E5RHdDO0FBMEVuREYsRUFBQUEsYUFBYSxFQUFFO0FBQ2JGLElBQUFBLEdBQUcsRUFBRTtBQUNIUixNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUCxLQURRO0FBTWJILElBQUFBLEdBQUcsRUFBRTtBQUNIVCxNQUFBQSxRQUFRLEVBQUU7QUFDUlksUUFBQUEsS0FBSyxFQUFFO0FBREM7QUFEUDtBQU5RLEdBMUVvQztBQXNGbkRELEVBQUFBLFFBQVEsRUFBRTtBQUNSSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFAsS0FERztBQU1SSCxJQUFBQSxHQUFHLEVBQUU7QUFDSFQsTUFBQUEsUUFBUSxFQUFFO0FBQ1JZLFFBQUFBLEtBQUssRUFBRTtBQURDO0FBRFA7QUFORyxHQXRGeUM7QUFrR25EQyxFQUFBQSxZQUFZLEVBQUU7QUFDWkMsSUFBQUEsR0FBRyxFQUFFO0FBQ0hkLE1BQUFBLFFBQVEsRUFBRTtBQUNSWSxRQUFBQSxLQUFLLEVBQUU7QUFEQztBQURQO0FBRE87QUFsR3FDLENBQTlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBDb3VudGVyc1R5cGUgfSBmcm9tICcuL3R5cGVzJztcbmltcG9ydCBTaG93ZG93biBmcm9tICdzaG93ZG93bic7XG5cbmV4cG9ydCBlbnVtIEZPUk1BVCB7XG4gIHBkZiA9ICdwZGYnLFxuICBwbmcgPSAncG5nJyxcbiAgY3N2ID0gJ2NzdicsXG59XG5cbmV4cG9ydCBlbnVtIFJFUE9SVF9TVEFURSB7XG4gIGNyZWF0ZWQgPSAnQ3JlYXRlZCcsXG4gIGVycm9yID0gJ0Vycm9yJyxcbiAgcGVuZGluZyA9ICdQZW5kaW5nJyxcbiAgc2hhcmVkID0gJ1NoYXJlZCcsXG59XG5cbmV4cG9ydCBlbnVtIFJFUE9SVF9ERUZJTklUSU9OX1NUQVRVUyB7XG4gIGFjdGl2ZSA9ICdBY3RpdmUnLFxuICBkaXNhYmxlZCA9ICdEaXNhYmxlZCcsXG59XG5cbmV4cG9ydCBlbnVtIERFTElWRVJZX0NIQU5ORUwge1xuICBlbWFpbCA9ICdFbWFpbCcsXG4gIHNsYWNrID0gJ1NsYWNrJyxcbiAgY2hpbWUgPSAnQ2hpbWUnLFxuICBvcGVuc2VhcmNoRGFzaGJvYXJkcyA9ICdPcGVuU2VhcmNoIERhc2hib2FyZHMgdXNlcicsXG59XG5cbmV4cG9ydCBlbnVtIFNDSEVEVUxFX1RZUEUge1xuICByZWN1cnJpbmcgPSAnUmVjdXJyaW5nJyxcbiAgY3JvbiA9ICdDcm9uIGJhc2VkJyxcbn1cblxuZXhwb3J0IGVudW0gUkVQT1JUX1RZUEUge1xuICBzYXZlZFNlYXJjaCA9ICdTYXZlZCBzZWFyY2gnLFxuICBkYXNoYm9hcmQgPSAnRGFzaGJvYXJkJyxcbiAgdmlzdWFsaXphdGlvbiA9ICdWaXN1YWxpemF0aW9uJyxcbiAgbm90ZWJvb2sgPSAnTm90ZWJvb2snLFxufVxuXG5leHBvcnQgZW51bSBEQVRBX1JFUE9SVF9DT05GSUcge1xuICBleGNlbERhdGVGb3JtYXQgPSAnTU0vREQvWVlZWSBoOm1tOnNzLlNTUyBhJyxcbn1cblxuZXhwb3J0IGVudW0gVFJJR0dFUl9UWVBFIHtcbiAgc2NoZWR1bGUgPSAnU2NoZWR1bGUnLFxuICBvbkRlbWFuZCA9ICdPbiBkZW1hbmQnLFxufVxuXG5leHBvcnQgZW51bSBERUxJVkVSWV9UWVBFIHtcbiAgb3BlbnNlYXJjaERhc2hib2FyZHNVc2VyID0gJ09wZW5TZWFyY2ggRGFzaGJvYXJkcyB1c2VyJyxcbiAgY2hhbm5lbCA9ICdDaGFubmVsJyxcbn1cblxuLy8gaHR0cHM6Ly93d3cuZWxhc3RpYy5jby9ndWlkZS9lbi9lbGFzdGljc2VhcmNoL3JlZmVyZW5jZS82Ljgvc2VhcmNoLXJlcXVlc3QtZnJvbS1zaXplLmh0bWxcbmV4cG9ydCBjb25zdCBERUZBVUxUX01BWF9TSVpFID0gMTAwMDA7XG5cbmV4cG9ydCBjb25zdCBTRUNVUklUWV9DT05TVEFOVFMgPSB7XG4gIFRFTkFOVF9MT0NBTF9TVE9SQUdFX0tFWTogJ29wZW5kaXN0cm86OnNlY3VyaXR5Ojp0ZW5hbnQ6OnNob3dfcG9wdXAnLFxufTtcblxuZXhwb3J0IGNvbnN0IEVYVFJBX0hFQURFUlMgPSBbXG4gICdjb29raWUnLFxuICAneC1wcm94eS11c2VyJyxcbiAgJ3gtcHJveHktcm9sZXMnLFxuICAneC1mb3J3YXJkZWQtZm9yJyxcbl07XG5cbmNvbnN0IEJMT0NLRURfS0VZV09SRCA9ICdCTE9DS0VEX0tFWVdPUkQnO1xuY29uc3QgaXB2NFJlZ2V4ID0gLygyNVswLTVdfDJbMC00XVswLTldfFswMV0/WzAtOV1bMC05XT8pXFwuKDI1WzAtNV18MlswLTRdWzAtOV18WzAxXT9bMC05XVswLTldPylcXC4oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KVxcLigyNVswLTVdfDJbMC00XVswLTldfFswMV0/WzAtOV1bMC05XT8pOihbMS05XVswLTldezAsM318WzEtNV1bMC05XXs0fXw2WzAtNF1bMC05XXszfXw2NVswLTRdWzAtOV17Mn18NjU1WzAtMl1bMC05XXw2NTUzWzAtNV0pL2dcbmNvbnN0IGlwdjZSZWdleCA9IC8oKFswLTlhLWZBLUZdezEsNH06KXs3LDd9WzAtOWEtZkEtRl17MSw0fXwoWzAtOWEtZkEtRl17MSw0fTopezEsN306fChbMC05YS1mQS1GXXsxLDR9Oil7MSw2fTpbMC05YS1mQS1GXXsxLDR9fChbMC05YS1mQS1GXXsxLDR9Oil7MSw1fSg6WzAtOWEtZkEtRl17MSw0fSl7MSwyfXwoWzAtOWEtZkEtRl17MSw0fTopezEsNH0oOlswLTlhLWZBLUZdezEsNH0pezEsM318KFswLTlhLWZBLUZdezEsNH06KXsxLDN9KDpbMC05YS1mQS1GXXsxLDR9KXsxLDR9fChbMC05YS1mQS1GXXsxLDR9Oil7MSwyfSg6WzAtOWEtZkEtRl17MSw0fSl7MSw1fXxbMC05YS1mQS1GXXsxLDR9OigoOlswLTlhLWZBLUZdezEsNH0pezEsNn0pfDooKDpbMC05YS1mQS1GXXsxLDR9KXsxLDd9fDopfGZlODA6KDpbMC05YS1mQS1GXXswLDR9KXswLDR9JVswLTlhLXpBLVpdezEsfXw6OihmZmZmKDowezEsNH0pezAsMX06KXswLDF9KCgyNVswLTVdfCgyWzAtNF18MXswLDF9WzAtOV0pezAsMX1bMC05XSlcXC4pezMsM30oMjVbMC01XXwoMlswLTRdfDF7MCwxfVswLTldKXswLDF9WzAtOV0pfChbMC05YS1mQS1GXXsxLDR9Oil7MSw0fTooKDI1WzAtNV18KDJbMC00XXwxezAsMX1bMC05XSl7MCwxfVswLTldKVxcLil7MywzfSgyNVswLTVdfCgyWzAtNF18MXswLDF9WzAtOV0pezAsMX1bMC05XSkpL2c7XG5jb25zdCBsb2NhbGhvc3RSZWdleCA9IC9sb2NhbGhvc3Q6KFsxLTldWzAtOV17MCwzfXxbMS01XVswLTldezR9fDZbMC00XVswLTldezN9fDY1WzAtNF1bMC05XXsyfXw2NTVbMC0yXVswLTldfDY1NTNbMC01XSkvZztcbmNvbnN0IGlmcmFtZVJlZ2V4ID0gL2lmcmFtZS9nO1xuXG5leHBvcnQgY29uc3QgQUxMT1dFRF9IT1NUUyA9IC9eKDB8MC4wLjAuMHwxMjcuMC4wLjF8bG9jYWxob3N0fCguKlxcLik/KG9wZW5zZWFyY2gub3JnfGF3cy5hMnouY29tKSkkLztcblxuZXhwb3J0IGNvbnN0IHJlcGxhY2VCbG9ja2VkS2V5d29yZHMgPSAoaHRtbFN0cmluZzogc3RyaW5nKSA9PiB7XG4gIC8vIHJlcGxhY2UgPGlwdjQ+Ojxwb3J0PlxuICBodG1sU3RyaW5nID0gaHRtbFN0cmluZy5yZXBsYWNlKGlwdjRSZWdleCwgQkxPQ0tFRF9LRVlXT1JEKTtcbiAgLy8gcmVwbGFjZSBpcHY2IGFkZHJlc3Nlc1xuICBodG1sU3RyaW5nID0gaHRtbFN0cmluZy5yZXBsYWNlKGlwdjZSZWdleCwgQkxPQ0tFRF9LRVlXT1JEKTtcbiAgLy8gcmVwbGFjZSBpZnJhbWUga2V5d29yZFxuICBodG1sU3RyaW5nID0gaHRtbFN0cmluZy5yZXBsYWNlKGlmcmFtZVJlZ2V4LCBCTE9DS0VEX0tFWVdPUkQpO1xuICAvLyByZXBsYWNlIGxvY2FsaG9zdDo8cG9ydD5cbiAgaHRtbFN0cmluZyA9IGh0bWxTdHJpbmcucmVwbGFjZShsb2NhbGhvc3RSZWdleCwgQkxPQ0tFRF9LRVlXT1JEKTtcbiAgcmV0dXJuIGh0bWxTdHJpbmc7XG59XG5cblxuLyoqXG4gKiBNZXRyaWMgY29uc3RhbnRzXG4gKi9cbmV4cG9ydCBjb25zdCBXSU5ET1cgPSAzNjAwO1xuZXhwb3J0IGNvbnN0IElOVEVSVkFMID0gNjA7XG5leHBvcnQgY29uc3QgQ0FQQUNJVFkgPSAoV0lORE9XIC8gSU5URVJWQUwpICogMjtcblxuZXhwb3J0IGNvbnN0IEdMT0JBTF9CQVNJQ19DT1VOVEVSOiBDb3VudGVyc1R5cGUgPSB7XG4gIHJlcG9ydDoge1xuICAgIGNyZWF0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBjcmVhdGVfZnJvbV9kZWZpbml0aW9uOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGRvd25sb2FkOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGxpc3Q6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgaW5mbzoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgfSxcbiAgcmVwb3J0X2RlZmluaXRpb246IHtcbiAgICBjcmVhdGU6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIHVwZGF0ZToge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBkZWxldGU6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9zb3VyY2U6IHtcbiAgICBsaXN0OiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICB9LFxuICBkYXNoYm9hcmQ6IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIHRvdGFsOiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHZpc3VhbGl6YXRpb246IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIHRvdGFsOiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgdG90YWw6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIG5vdGVib29rOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICBzYXZlZF9zZWFyY2g6IHtcbiAgICBjc3Y6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIHRvdGFsOiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxufTtcblxuZXhwb3J0IGNvbnN0IERFRkFVTFRfUk9MTElOR19DT1VOVEVSOiBDb3VudGVyc1R5cGUgPSB7XG4gIHJlcG9ydDoge1xuICAgIGNyZWF0ZToge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgY3JlYXRlX2Zyb21fZGVmaW5pdGlvbjoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgZG93bmxvYWQ6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGxpc3Q6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGluZm86IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICB9LFxuICByZXBvcnRfZGVmaW5pdGlvbjoge1xuICAgIGNyZWF0ZToge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgbGlzdDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgaW5mbzoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgdXBkYXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBkZWxldGU6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICB9LFxuICByZXBvcnRfc291cmNlOiB7XG4gICAgbGlzdDoge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gIH0sXG4gIGRhc2hib2FyZDoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgdmlzdWFsaXphdGlvbjoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgbm90ZWJvb2s6IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHNhdmVkX3NlYXJjaDoge1xuICAgIGNzdjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuIl19