"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricsRoute = registerMetricsRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../../common/constants/shared");

var _metrics_helper = require("../../common/metrics/metrics_helper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerMetricsRoute(router) {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}/stats`,
    validate: false
  }, async (context, request, response) => {
    try {
      const metrics = (0, _metrics_helper.getMetrics)();
      return response.ok({
        body: metrics
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}/stats`,
    validate: {
      body: _configSchema.schema.object({
        element: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const {
        element
      } = request.body;
      (0, _metrics_helper.addClickToMetric)(element);
      return response.ok();
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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