"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = exports.setQueryManager = exports.setPPLService = exports.setOSDSavedObjectsClient = exports.setOSDHttp = exports.getQueryManager = exports.getPPLService = exports.getOSDSavedObjectsClient = exports.getOSDHttp = void 0;

var _common = require("../../../../src/plugins/opensearch_dashboards_utils/common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let uiSettings;
let notifications;
const uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;

    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;

    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject('uiSettings client not initialized.');
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
exports.uiSettingsService = uiSettingsService;
const [getPPLService, setPPLService] = (0, _common.createGetterSetter)('PPLService');
exports.setPPLService = setPPLService;
exports.getPPLService = getPPLService;
const [getOSDHttp, setOSDHttp] = (0, _common.createGetterSetter)('http');
exports.setOSDHttp = setOSDHttp;
exports.getOSDHttp = getOSDHttp;
const [getOSDSavedObjectsClient, setOSDSavedObjectsClient] = (0, _common.createGetterSetter)('SavedObjectsClient');
exports.setOSDSavedObjectsClient = setOSDSavedObjectsClient;
exports.getOSDSavedObjectsClient = getOSDSavedObjectsClient;
const [getQueryManager, setQueryManager] = (0, _common.createGetterSetter)('QueryManager');
exports.setQueryManager = setQueryManager;
exports.getQueryManager = getQueryManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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