"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateModelSearchQuery = void 0;

var _query = require("./query");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const generateModelSearchQuery = ({
  states,
  nameOrId,
  extraQuery
}) => ({
  bool: {
    must: [...(states ? [(0, _query.generateTermQuery)('model_state', states)] : []), ...(nameOrId ? [{
      bool: {
        should: [{
          wildcard: {
            'name.keyword': {
              value: `*${nameOrId}*`,
              case_insensitive: true
            }
          }
        }, (0, _query.generateTermQuery)('_id', nameOrId)]
      }
    }] : []), ...(extraQuery ? [extraQuery] : [])],
    must_not: {
      exists: {
        field: 'chunk_number'
      }
    }
  }
});

exports.generateModelSearchQuery = generateModelSearchQuery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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