"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AliasServices {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const client = this.osDriver.asScoped(request);
        const [aliases, apiAccessible, errMsg] = await getAliases(client, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }

}

exports.default = AliasServices;

async function getAliases({
  callAsCurrentUser: callWithRequest
}, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }

    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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