"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function defineRoutes(router) {
  router.post({
    path: '/api/gantt_vis/query',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string(),
        size: _configSchema.schema.number(),
        body: _configSchema.schema.object({
          query: _configSchema.schema.maybe(_configSchema.schema.object({
            bool: _configSchema.schema.object({
              filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              }))),
              must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
                unknowns: 'allow'
              })))
            })
          })),
          sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any()))
        })
      })
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      ...rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: {
          total: resp.hits.total.value,
          hits: resp.hits.hits
        }
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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