"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.aadFactory = void 0;
/*
 * This public interface for constructing the additional authenticated data (AAD)
 * is provided for the use of the Encryption SDK for JavaScript only.  It can be used
 * as a reference but is not intended to be use by any packages other than the
 * Encryption SDK for JavaScript.
 *
 * This AAD is used for the Body section
 * See: https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/body-aad-reference.html
 */
const bn_js_1 = __importDefault(require("bn.js"));
const identifiers_1 = require("./identifiers");
const concat_buffers_1 = require("./concat_buffers");
const uint_util_1 = require("./uint_util");
function aadFactory(fromUtf8) {
    return {
        messageAADContentString,
        messageAAD,
    };
    function messageAADContentString({ contentType, isFinalFrame, }) {
        switch (contentType) {
            case identifiers_1.ContentType.NO_FRAMING:
                return identifiers_1.ContentAADString.NON_FRAMED_STRING_ID;
            case identifiers_1.ContentType.FRAMED_DATA:
                return isFinalFrame
                    ? identifiers_1.ContentAADString.FINAL_FRAME_STRING_ID
                    : identifiers_1.ContentAADString.FRAME_STRING_ID;
            default:
                throw new Error('Unrecognized content type');
        }
    }
    function messageAAD(messageId, aadContentString, seqNum, contentLength) {
        return (0, concat_buffers_1.concatBuffers)(messageId, fromUtf8(aadContentString), (0, uint_util_1.uInt32BE)(seqNum), new Uint8Array(new bn_js_1.default(contentLength).toArray('be', 8)));
    }
}
exports.aadFactory = aadFactory;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWFkX2ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYWFkX2ZhY3RvcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7Ozs7OztBQUV0Qzs7Ozs7Ozs7R0FRRztBQUVILGtEQUFzQjtBQUN0QiwrQ0FBNkQ7QUFFN0QscURBQWdEO0FBQ2hELDJDQUFzQztBQUV0QyxTQUFnQixVQUFVLENBQUMsUUFBdUM7SUFDaEUsT0FBTztRQUNMLHVCQUF1QjtRQUN2QixVQUFVO0tBQ1gsQ0FBQTtJQUVELFNBQVMsdUJBQXVCLENBQUMsRUFDL0IsV0FBVyxFQUNYLFlBQVksR0FJYjtRQUNDLFFBQVEsV0FBVyxFQUFFO1lBQ25CLEtBQUsseUJBQVcsQ0FBQyxVQUFVO2dCQUN6QixPQUFPLDhCQUFnQixDQUFDLG9CQUFvQixDQUFBO1lBQzlDLEtBQUsseUJBQVcsQ0FBQyxXQUFXO2dCQUMxQixPQUFPLFlBQVk7b0JBQ2pCLENBQUMsQ0FBQyw4QkFBZ0IsQ0FBQyxxQkFBcUI7b0JBQ3hDLENBQUMsQ0FBQyw4QkFBZ0IsQ0FBQyxlQUFlLENBQUE7WUFDdEM7Z0JBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQywyQkFBMkIsQ0FBQyxDQUFBO1NBQy9DO0lBQ0gsQ0FBQztJQUVELFNBQVMsVUFBVSxDQUNqQixTQUFxQixFQUNyQixnQkFBa0MsRUFDbEMsTUFBYyxFQUNkLGFBQXFCO1FBRXJCLE9BQU8sSUFBQSw4QkFBYSxFQUNsQixTQUFTLEVBQ1QsUUFBUSxDQUFDLGdCQUFnQixDQUFDLEVBQzFCLElBQUEsb0JBQVEsRUFBQyxNQUFNLENBQUMsRUFDaEIsSUFBSSxVQUFVLENBQUMsSUFBSSxlQUFFLENBQUMsYUFBYSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUN2RCxDQUFBO0lBQ0gsQ0FBQztBQUNILENBQUM7QUF0Q0QsZ0NBc0NDIn0=