// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
export function immutableClass(ObjectClass) {
    Object.freeze(ObjectClass);
    const propertyNames = Object.getOwnPropertyNames(ObjectClass.prototype);
    propertyNames
        .filter((name) => name !== 'constructor')
        .forEach((name) => Object.defineProperty(ObjectClass.prototype, name, { writable: false }));
    Object.seal(ObjectClass.prototype);
    return ObjectClass;
}
export function immutableBaseClass(ObjectClass) {
    Object.setPrototypeOf(ObjectClass.prototype, null);
    immutableClass(ObjectClass);
    return ObjectClass;
}
export function frozenClass(ObjectClass) {
    Object.setPrototypeOf(ObjectClass.prototype, null);
    Object.freeze(ObjectClass.prototype);
    Object.freeze(ObjectClass);
    return ObjectClass;
}
export function readOnlyBinaryProperty(obj, name, value) {
    // should this also add a zero property?
    // and should it create a local value?  maybe not.
    const safeValue = new Uint8Array(value);
    Object.defineProperty(obj, name, {
        get: () => new Uint8Array(safeValue),
        enumerable: true,
    });
}
export function readOnlyProperty(obj, name, value) {
    Object.defineProperty(obj, name, { value, enumerable: true });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1tdXRhYmxlX2NsYXNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2ltbXV0YWJsZV9jbGFzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE1BQU0sVUFBVSxjQUFjLENBQUMsV0FBZ0I7SUFDN0MsTUFBTSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQTtJQUMxQixNQUFNLGFBQWEsR0FBRyxNQUFNLENBQUMsbUJBQW1CLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxDQUFBO0lBQ3ZFLGFBQWE7U0FDVixNQUFNLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksS0FBSyxhQUFhLENBQUM7U0FDeEMsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FDaEIsTUFBTSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsU0FBUyxFQUFFLElBQUksRUFBRSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUN4RSxDQUFBO0lBQ0gsTUFBTSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDbEMsT0FBTyxXQUFXLENBQUE7QUFDcEIsQ0FBQztBQUVELE1BQU0sVUFBVSxrQkFBa0IsQ0FBQyxXQUFnQjtJQUNqRCxNQUFNLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUE7SUFDbEQsY0FBYyxDQUFDLFdBQVcsQ0FBQyxDQUFBO0lBQzNCLE9BQU8sV0FBVyxDQUFBO0FBQ3BCLENBQUM7QUFFRCxNQUFNLFVBQVUsV0FBVyxDQUFDLFdBQWdCO0lBQzFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQTtJQUNsRCxNQUFNLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQTtJQUNwQyxNQUFNLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxDQUFBO0lBQzFCLE9BQU8sV0FBVyxDQUFBO0FBQ3BCLENBQUM7QUFFRCxNQUFNLFVBQVUsc0JBQXNCLENBQ3BDLEdBQVEsRUFDUixJQUFZLEVBQ1osS0FBaUI7SUFFakIsd0NBQXdDO0lBQ3hDLGtEQUFrRDtJQUNsRCxNQUFNLFNBQVMsR0FBRyxJQUFJLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQTtJQUN2QyxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUU7UUFDL0IsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUNwQyxVQUFVLEVBQUUsSUFBSTtLQUNqQixDQUFDLENBQUE7QUFDSixDQUFDO0FBRUQsTUFBTSxVQUFVLGdCQUFnQixDQUM5QixHQUFNLEVBQ04sSUFBTyxFQUNQLEtBQVc7SUFFWCxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUUsRUFBRSxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUE7QUFDL0QsQ0FBQyJ9