"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.KMS = exports.cacheClients = exports.excludeRegions = exports.limitRegions = exports.getClient = exports.cacheKmsClients = exports.getKmsClient = exports.KmsKeyringNode = void 0;
const kms_keyring_1 = require("@aws-crypto/kms-keyring");
Object.defineProperty(exports, "getClient", { enumerable: true, get: function () { return kms_keyring_1.getClient; } });
Object.defineProperty(exports, "limitRegions", { enumerable: true, get: function () { return kms_keyring_1.limitRegions; } });
Object.defineProperty(exports, "excludeRegions", { enumerable: true, get: function () { return kms_keyring_1.excludeRegions; } });
Object.defineProperty(exports, "cacheClients", { enumerable: true, get: function () { return kms_keyring_1.cacheClients; } });
const material_management_node_1 = require("@aws-crypto/material-management-node");
const aws_sdk_1 = require("aws-sdk");
Object.defineProperty(exports, "KMS", { enumerable: true, get: function () { return aws_sdk_1.KMS; } });
const version_1 = require("./version");
const getKmsClient = (0, kms_keyring_1.getClient)(aws_sdk_1.KMS, {
    customUserAgent: `AwsEncryptionSdkJavascriptNodejs/${version_1.version}`,
});
exports.getKmsClient = getKmsClient;
const cacheKmsClients = (0, kms_keyring_1.cacheClients)(getKmsClient);
exports.cacheKmsClients = cacheKmsClients;
class KmsKeyringNode extends (0, kms_keyring_1.KmsKeyringClass)(material_management_node_1.KeyringNode) {
    constructor({ clientProvider = cacheKmsClients, keyIds, generatorKeyId, grantTokens, discovery, } = {}) {
        super({ clientProvider, keyIds, generatorKeyId, grantTokens, discovery });
    }
}
exports.KmsKeyringNode = KmsKeyringNode;
(0, material_management_node_1.immutableClass)(KmsKeyringNode);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zX2tleXJpbmdfbm9kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9rbXNfa2V5cmluZ19ub2RlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDOzs7QUFFdEMseURBU2dDO0FBdUM5QiwwRkEzQ0EsdUJBQVMsT0EyQ0E7QUFDVCw2RkEzQ0EsMEJBQVksT0EyQ0E7QUFDWiwrRkEzQ0EsNEJBQWMsT0EyQ0E7QUFDZCw2RkEzQ0EsMEJBQVksT0EyQ0E7QUF6Q2QsbUZBSzZDO0FBQzdDLHFDQUE2QjtBQW9DM0Isb0ZBcENPLGFBQUcsT0FvQ1A7QUFuQ0wsdUNBQW1DO0FBQ25DLE1BQU0sWUFBWSxHQUFHLElBQUEsdUJBQVMsRUFBQyxhQUFHLEVBQUU7SUFDbEMsZUFBZSxFQUFFLG9DQUFvQyxpQkFBTyxFQUFFO0NBQy9ELENBQUMsQ0FBQTtBQTBCQSxvQ0FBWTtBQXpCZCxNQUFNLGVBQWUsR0FBRyxJQUFBLDBCQUFZLEVBQUMsWUFBWSxDQUFDLENBQUE7QUEwQmhELDBDQUFlO0FBakJqQixNQUFhLGNBQWUsU0FBUSxJQUFBLDZCQUFlLEVBQ2pELHNDQUFtQyxDQUNwQztJQUNDLFlBQVksRUFDVixjQUFjLEdBQUcsZUFBZSxFQUNoQyxNQUFNLEVBQ04sY0FBYyxFQUNkLFdBQVcsRUFDWCxTQUFTLE1BQ2MsRUFBRTtRQUN6QixLQUFLLENBQUMsRUFBRSxjQUFjLEVBQUUsTUFBTSxFQUFFLGNBQWMsRUFBRSxXQUFXLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQTtJQUMzRSxDQUFDO0NBQ0Y7QUFaRCx3Q0FZQztBQUNELElBQUEseUNBQWMsRUFBQyxjQUFjLENBQUMsQ0FBQSJ9