/*
 * Decompiled with CFR 0.152.
 */
package lucee.debug;

import java.io.File;
import java.lang.reflect.Method;

public class Main {
    public static final String ARG_HOST = "LUCEE_DEBUG_HOST";
    public static final String ARG_PORT = "LUCEE_DEBUG_PORT";
    public static final String ARG_BASE = "LUCEE_DEBUG_BASE";
    public static final String ARG_WEBXML = "LUCEE_DEBUG_BASE";
    public static final String DEF_HOST = "localhost";
    public static final String DEF_PORT = "48080";
    public static final String DEF_BASE = "/workspace/test/LuceeDebugWebapp";

    public static void main(String[] args) throws Exception {
        System.setProperty("lucee.controller.disabled", "true");
        String webxml = Main.getSystemPropOrEnvVar("LUCEE_DEBUG_BASE", "");
        if (webxml.isEmpty()) {
            webxml = Main.class.getResource("/debug/web.xml").getPath();
        }
        String s = Main.getSystemPropOrEnvVar("LUCEE_DEBUG_BASE", DEF_BASE);
        String appBase = new File(s).getCanonicalPath().replace('\\', '/');
        String docBase = appBase + "/webroot";
        System.out.println("Setting appBase: " + appBase);
        System.out.println("Setting docBase: " + docBase);
        Class<?> clsTomcat = Class.forName("org.apache.catalina.startup.Tomcat");
        Method tAddWebApp = clsTomcat.getMethod("addWebapp", String.class, String.class);
        Method tGetConnector = clsTomcat.getMethod("getConnector", new Class[0]);
        Method tGetServer = clsTomcat.getMethod("getServer", new Class[0]);
        Method tSetAddDefaultWebXmlToWebapp = clsTomcat.getMethod("setAddDefaultWebXmlToWebapp", Boolean.TYPE);
        Method tSetBaseDir = clsTomcat.getMethod("setBaseDir", String.class);
        Method tSetHostname = clsTomcat.getMethod("setHostname", String.class);
        Method tSetPort = clsTomcat.getMethod("setPort", Integer.TYPE);
        Method tStart = clsTomcat.getMethod("start", new Class[0]);
        Class<?> clsContext = Class.forName("org.apache.catalina.Context");
        Method cSetAltDDName = clsContext.getMethod("setAltDDName", String.class);
        Method cSetLogEffectiveWebXml = clsContext.getMethod("setLogEffectiveWebXml", Boolean.TYPE);
        Method cSetResourceOnlyServlets = clsContext.getMethod("setResourceOnlyServlets", String.class);
        Class<?> clsServer = Class.forName("org.apache.catalina.Server");
        Method sAwait = clsServer.getMethod("await", new Class[0]);
        Object oTomcat = clsTomcat.newInstance();
        tSetBaseDir.invoke(oTomcat, appBase);
        s = Main.getSystemPropOrEnvVar(ARG_HOST, DEF_HOST);
        tSetHostname.invoke(oTomcat, s);
        s = Main.getSystemPropOrEnvVar(ARG_PORT, DEF_PORT);
        tSetPort.invoke(oTomcat, Integer.parseInt(s));
        tSetAddDefaultWebXmlToWebapp.invoke(oTomcat, false);
        Object oContext = tAddWebApp.invoke(oTomcat, "", docBase);
        cSetAltDDName.invoke(oContext, webxml);
        cSetLogEffectiveWebXml.invoke(oContext, true);
        cSetResourceOnlyServlets.invoke(oContext, "CFMLServlet");
        System.out.println(tGetConnector.invoke(oTomcat, new Object[0]));
        tStart.invoke(oTomcat, new Object[0]);
        Object oServer = tGetServer.invoke(oTomcat, new Object[0]);
        sAwait.invoke(oServer, new Object[0]);
    }

    private static String convertSystemPropToEnvVar(String name) {
        return name.replace('.', '_').toUpperCase();
    }

    private static String getSystemPropOrEnvVar(String name, String defaultValue) {
        String value = System.getenv(name);
        if (!Main.isEmpty(value)) {
            return value;
        }
        value = System.getProperty(name);
        if (!Main.isEmpty(value)) {
            return value;
        }
        value = System.getenv(name = Main.convertSystemPropToEnvVar(name));
        if (!Main.isEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

