/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ResourceServerUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;

    public static ResourceServerUpdatedEvent create(String id) {
        ResourceServerUpdatedEvent event = new ResourceServerUpdatedEvent();
        event.id = id;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("ResourceServerRemovedEvent [ id=%s, clientId=%s ]", this.id, this.id);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceServerUpdated(this.id, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ResourceServerUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ResourceServerUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
        }

        public ResourceServerUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ResourceServerUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ResourceServerUpdatedEvent res = new ResourceServerUpdatedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

