/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.web;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.transaction.TransactionalSessionHandler;

public class QuarkusRequestFilter
implements Handler<RoutingContext>,
TransactionalSessionHandler {
    private final ExecutorService executor;
    private Predicate<RoutingContext> contextFilter;

    public QuarkusRequestFilter() {
        this(null, null);
    }

    public QuarkusRequestFilter(Predicate<RoutingContext> contextFilter, ExecutorService executor) {
        this.contextFilter = contextFilter;
        this.executor = executor;
    }

    public void handle(RoutingContext context) {
        if (this.ignoreContext(context)) {
            context.next();
            return;
        }
        this.executor.execute(this.createBlockingHandler(context));
    }

    private boolean ignoreContext(RoutingContext context) {
        return this.contextFilter != null && this.contextFilter.test(context);
    }

    private Runnable createBlockingHandler(RoutingContext context) {
        return () -> {
            KeycloakSession session = this.configureContextualData(context);
            try {
                context.next();
            }
            catch (Throwable cause) {
                throw new RuntimeException(cause);
            }
            finally {
                this.close(session);
            }
        };
    }

    private KeycloakSession configureContextualData(RoutingContext context) {
        KeycloakSession session = this.create();
        Resteasy.pushContext(KeycloakSession.class, (Object)session);
        context.put(KeycloakSession.class.getName(), (Object)session);
        ClientConnection connection = this.createClientConnection(context.request());
        Resteasy.pushContext(ClientConnection.class, (Object)connection);
        context.put(ClientConnection.class.getName(), (Object)connection);
        return session;
    }

    private ClientConnection createClientConnection(final HttpServerRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }

            public String getRemoteHost() {
                return request.remoteAddress().host();
            }

            public int getRemotePort() {
                return request.remoteAddress().port();
            }

            public String getLocalAddr() {
                return request.localAddress().host();
            }

            public int getLocalPort() {
                return request.localAddress().port();
            }
        };
    }
}

