/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.lang.invoke.MethodHandles;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.DelegatingRemoteCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.AddBloomNearCacheClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.client.hotrod.impl.operations.UpdateBloomFilterOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCacheService;

public class InvalidatedNearRemoteCache<K, V>
extends DelegatingRemoteCache<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final NearCacheService<K, V> nearcache;
    private final ClientStatistics clientStatistics;
    private final AtomicInteger bloomFilterUpdateVersion;
    private volatile SocketAddress listenerAddress;

    InvalidatedNearRemoteCache(InternalRemoteCache<K, V> remoteCache, ClientStatistics clientStatistics, NearCacheService<K, V> nearcache) {
        super(remoteCache);
        this.clientStatistics = clientStatistics;
        this.nearcache = nearcache;
        this.bloomFilterUpdateVersion = nearcache.getBloomFilterBits() > 0 ? new AtomicInteger() : null;
    }

    @Override
    <Key, Value> InternalRemoteCache<Key, Value> newDelegatingCache(InternalRemoteCache<Key, Value> innerCache) {
        return new InvalidatedNearRemoteCache<Key, Value>(innerCache, this.clientStatistics, this.nearcache);
    }

    public static <K, V> InvalidatedNearRemoteCache<K, V> delegatingNearCache(RemoteCacheImpl<K, V> remoteCache, NearCacheService<K, V> nearCacheService) {
        return new InvalidatedNearRemoteCache<K, V>(remoteCache, remoteCache.clientStatistics, nearCacheService);
    }

    @Override
    public CompletableFuture<V> getAsync(Object key) {
        CompletableFuture<MetadataValue<V>> value = this.getWithMetadataAsync(key);
        return value.thenApply(v -> v != null ? v.getValue() : null);
    }

    private int getCurrentVersion() {
        if (this.bloomFilterUpdateVersion != null) {
            return this.bloomFilterUpdateVersion.get();
        }
        return 0;
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        MetadataValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null || nearValue.getValue() == null) {
            this.clientStatistics.incrementNearCacheMisses();
            MetadataValueImpl<Object> calculatingPlaceholder = new MetadataValueImpl<Object>(-1L, -1, -1L, -1, -1L, null);
            boolean cache = this.nearcache.putIfAbsent(key, calculatingPlaceholder);
            int prevVersion = this.getCurrentVersion();
            RetryAwareCompletionStage remoteValue = super.getWithMetadataAsync(key, this.listenerAddress);
            if (!cache) {
                return remoteValue.toCompletableFuture();
            }
            return remoteValue.thenApply(v -> {
                boolean shouldRemove = true;
                if (v != null) {
                    if ((prevVersion & 1) == 1 || prevVersion != this.getCurrentVersion()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was performed during a bloom filter update", new Object[0]);
                        }
                    } else if (this.listenerAddress != null && remoteValue.wasRetried().booleanValue()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was retried", key);
                        }
                    } else {
                        this.nearcache.replace(key, calculatingPlaceholder, (MetadataValue<V>)v);
                        if (v.getMaxIdle() > 0) {
                            Log.HOTROD.nearCacheMaxIdleUnsupported();
                        }
                        shouldRemove = false;
                    }
                }
                if (shouldRemove) {
                    this.nearcache.remove(key, calculatingPlaceholder);
                }
                return v;
            }).toCompletableFuture();
        }
        this.clientStatistics.incrementNearCacheHits();
        return CompletableFuture.completedFuture(nearValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        CompletableFuture<V> ret = super.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return ret.thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit).thenRun(() -> map.keySet().forEach(this.nearcache::remove));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.removeAsync(key));
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return super.removeWithVersionAsync(key, version).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return super.clearAsync().thenRun(this.nearcache::clear);
    }

    CompletableFuture<V> invalidateNearCacheIfNeeded(boolean hasForceReturnValue, Object key, CompletableFuture<V> prev) {
        return prev.thenApply(v -> {
            if (!hasForceReturnValue || v != null) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public void start() {
        super.start();
        this.listenerAddress = this.nearcache.start(this);
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
        super.stop();
    }

    public void clearNearCache() {
        this.nearcache.clear();
    }

    private boolean incrementBloomVersionIfEven() {
        if (this.bloomFilterUpdateVersion != null) {
            int prev;
            do {
                if (((prev = this.bloomFilterUpdateVersion.get()) & 1) != 1) continue;
                return false;
            } while (!this.bloomFilterUpdateVersion.compareAndSet(prev, prev + 1));
        }
        return true;
    }

    CompletionStage<Void> incrementBloomVersionUponCompletion(CompletionStage<Void> stage) {
        if (this.bloomFilterUpdateVersion != null) {
            return stage.whenComplete((ignore, t) -> this.bloomFilterUpdateVersion.incrementAndGet());
        }
        return stage;
    }

    @Override
    public CompletionStage<Void> updateBloomFilter() {
        if (!this.incrementBloomVersionIfEven()) {
            if (trace) {
                log.tracef("Already have a concurrent bloom filter update for listenerId(%s) - skipping", org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
            }
            return CompletableFuture.completedFuture(null);
        }
        byte[] bloomFilterBits = this.nearcache.calculateBloomBits();
        if (trace) {
            log.tracef("Sending bloom filter bits(%s) update to %s for listenerId(%s)", org.infinispan.commons.util.Util.printArray((byte[])bloomFilterBits), this.listenerAddress, org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
        }
        OperationsFactory operationsFactory = this.getOperationsFactory();
        UpdateBloomFilterOperation bloopOp = operationsFactory.newUpdateBloomFilterOperation(this.listenerAddress, bloomFilterBits);
        return this.incrementBloomVersionUponCompletion(bloopOp.execute());
    }

    public SocketAddress getBloomListenerAddress() {
        return this.listenerAddress;
    }

    public void setBloomListenerAddress(SocketAddress socketAddress) {
        this.listenerAddress = socketAddress;
    }

    @Override
    public SocketAddress addNearCacheListener(Object listener, int bloomBits) {
        AddBloomNearCacheClientListenerOperation op = this.getOperationsFactory().newAddNearCacheListenerOperation(listener, this.getDataFormat(), bloomBits, this);
        return (SocketAddress)Util.await(op.execute());
    }
}

