/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.keycloak.locale.LocaleUpdaterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class LocaleUtil {
    private LocaleUtil() {
    }

    public static void processLocaleParam(KeycloakSession session, RealmModel realm, AuthenticationSessionModel authSession) {
        String locale;
        if (realm.isInternationalizationEnabled() && (locale = (String)session.getContext().getUri().getQueryParameters().getFirst((Object)"kc_locale")) != null) {
            if (authSession != null) {
                authSession.setAuthNote("locale_user_requested", locale);
            } else {
                session.setAttribute("locale_user_requested", (Object)locale);
            }
            LocaleUpdaterProvider localeUpdater = (LocaleUpdaterProvider)session.getProvider(LocaleUpdaterProvider.class);
            localeUpdater.updateLocaleCookie(locale);
        }
    }

    public static Locale getParentLocale(Locale locale) {
        if (locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        if (!Locale.ENGLISH.equals(locale)) {
            return Locale.ENGLISH;
        }
        return null;
    }

    static List<Locale> getApplicableLocales(Locale locale) {
        ArrayList<Locale> applicableLocales = new ArrayList<Locale>();
        Locale currentLocale = locale;
        while (currentLocale != null) {
            applicableLocales.add(currentLocale);
            currentLocale = LocaleUtil.getParentLocale(currentLocale);
        }
        return applicableLocales;
    }

    public static Properties mergeGroupedMessages(Locale locale, Map<Locale, Properties> messages) {
        return LocaleUtil.mergeGroupedMessages(locale, messages, null);
    }

    public static Properties mergeGroupedMessages(Locale locale, Map<Locale, Properties> firstMessages, Map<Locale, Properties> secondMessages) {
        List<Locale> applicableLocales = LocaleUtil.getApplicableLocales(locale);
        Properties mergedProperties = new Properties();
        ListIterator<Locale> itr = applicableLocales.listIterator(applicableLocales.size());
        while (itr.hasPrevious()) {
            Properties currentLocaleFirstMessages;
            Properties currentLocaleSecondMessages;
            Locale currentLocale = itr.previous();
            if (secondMessages != null && (currentLocaleSecondMessages = secondMessages.get(currentLocale)) != null) {
                mergedProperties.putAll((Map<?, ?>)currentLocaleSecondMessages);
            }
            if ((currentLocaleFirstMessages = firstMessages.get(currentLocale)) == null) continue;
            mergedProperties.putAll((Map<?, ?>)currentLocaleFirstMessages);
        }
        return mergedProperties;
    }

    public static Properties enhancePropertiesWithRealmLocalizationTexts(RealmModel realm, Locale locale, Map<Locale, Properties> themeMessages) {
        Map<Locale, Properties> realmLocalizationMessages = LocaleUtil.getRealmLocalizationTexts(realm, locale);
        return LocaleUtil.mergeGroupedMessages(locale, realmLocalizationMessages, themeMessages);
    }

    private static Map<Locale, Properties> getRealmLocalizationTexts(RealmModel realm, Locale locale) {
        LinkedHashMap<Locale, Properties> groupedMessages = new LinkedHashMap<Locale, Properties>();
        List<Locale> applicableLocales = LocaleUtil.getApplicableLocales(locale);
        for (Locale applicableLocale : applicableLocales) {
            Map currentRealmLocalizationTexts = realm.getRealmLocalizationTextsByLocale(applicableLocale.toLanguageTag());
            Properties currentMessages = new Properties();
            currentMessages.putAll((Map<?, ?>)currentRealmLocalizationTexts);
            groupedMessages.put(applicableLocale, currentMessages);
        }
        return groupedMessages;
    }
}

