/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.userprofile.UserProfileProvider;

@Extension(name="x-smallrye-profile-admin", value="")
public class UserProfileResource {
    protected final KeycloakSession session;
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public UserProfileResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
    }

    @GET
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public String getConfiguration() {
        this.auth.requireAnyAdminRole();
        return ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).getConfiguration();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Users")
    @Operation
    public Response update(String text) {
        this.auth.realm().requireManageRealm();
        UserProfileProvider t = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        try {
            t.setConfiguration(text);
        }
        catch (ComponentValidationException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        return Response.ok((Object)t.getConfiguration()).type("application/json").build();
    }
}

