/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.SessionAttributesUtils;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorageProviderFactory;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.SingleUseObjectMapStorage;

public class ConcurrentHashMapStorageProvider
implements MapStorageProvider {
    private final KeycloakSession session;
    private final ConcurrentHashMapStorageProviderFactory factory;
    private final int factoryId;

    public ConcurrentHashMapStorageProvider(KeycloakSession session, ConcurrentHashMapStorageProviderFactory factory, int factoryId) {
        this.session = session;
        this.factory = factory;
        this.factoryId = factoryId;
    }

    public void close() {
    }

    @Override
    public <V extends AbstractEntity, M> MapStorage<V, M> getMapStorage(Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        return SessionAttributesUtils.createMapStorageIfAbsent(this.session, this.getClass(), modelType, this.factoryId, () -> {
            ConcurrentHashMapStorage store = this.getMapStorage(modelType, this.factory.getStorage(modelType, flags));
            this.session.getTransactionManager().enlist((KeycloakTransaction)store);
            return store;
        });
    }

    private <K, V extends AbstractEntity & UpdatableEntity, M> ConcurrentHashMapStorage getMapStorage(Class<?> modelType, ConcurrentHashMapCrudOperations<K, V, M> crud) {
        if (modelType == SingleUseObjectValueModel.class) {
            return new SingleUseObjectMapStorage((CrudOperations<MapSingleUseObjectEntity, SingleUseObjectValueModel>)crud, this.factory.getKeyConverter(modelType), ConcurrentHashMapStorageProviderFactory.CLONER, MapFieldPredicates.getPredicates(modelType));
        }
        return new ConcurrentHashMapStorage(crud, this.factory.getKeyConverter(modelType), ConcurrentHashMapStorageProviderFactory.CLONER, MapFieldPredicates.getPredicates(modelType));
    }
}

