/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.admin.cli.common.AttributeOperation;
import org.keycloak.client.admin.cli.common.CmdStdinContext;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.util.AccessibleBufferOutputStream;
import org.keycloak.client.admin.cli.util.AuthUtil;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.Header;
import org.keycloak.client.admin.cli.util.Headers;
import org.keycloak.client.admin.cli.util.HeadersBody;
import org.keycloak.client.admin.cli.util.HeadersBodyStatus;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.OutputFormat;
import org.keycloak.client.admin.cli.util.OutputUtil;
import org.keycloak.client.admin.cli.util.ParseUtil;
import org.keycloak.client.admin.cli.util.ReflectionUtil;
import org.keycloak.client.admin.cli.util.ReturnFields;

public abstract class AbstractRequestCmd
extends AbstractAuthOptionsCmd {
    String file;
    String body;
    String fields;
    boolean printHeaders;
    boolean returnId;
    boolean outputResult;
    boolean compressed;
    boolean unquoted;
    boolean mergeMode;
    boolean noMerge;
    Integer offset;
    Integer limit;
    String format = "json";
    OutputFormat outputFormat;
    String httpVerb;
    Headers headers = new Headers();
    List<AttributeOperation> attrs = new LinkedList<AttributeOperation>();
    Map<String, String> filter = new HashMap<String, String>();
    String url = null;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            this.initOptions();
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            this.processOptions(commandInvocation);
            CommandResult commandResult = this.process(commandInvocation);
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    abstract void initOptions();

    abstract String suggestHelp();

    void processOptions(CommandInvocation commandInvocation) {
        if (this.args == null || this.args.isEmpty()) {
            throw new IllegalArgumentException("URI not specified");
        }
        Iterator<String> it = this.args.iterator();
        block18: while (it.hasNext()) {
            String option;
            switch (option = (String)it.next()) {
                case "-s": 
                case "--set": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("Option " + option + " requires a value");
                    }
                    String[] keyVal = ParseUtil.parseKeyVal(it.next());
                    this.attrs.add(new AttributeOperation(AttributeOperation.Type.SET, keyVal[0], keyVal[1]));
                    continue block18;
                }
                case "-d": 
                case "--delete": {
                    this.attrs.add(new AttributeOperation(AttributeOperation.Type.DELETE, it.next()));
                    continue block18;
                }
                case "-h": 
                case "--header": {
                    this.requireValue(it, option);
                    String[] keyVal = ParseUtil.parseKeyVal(it.next());
                    this.headers.add(keyVal[0], keyVal[1]);
                    continue block18;
                }
                case "-q": 
                case "--query": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("Option " + option + " requires a value");
                    }
                    String arg = it.next();
                    String[] keyVal = arg.indexOf("=") == -1 ? new String[]{"", arg} : ParseUtil.parseKeyVal(arg);
                    this.filter.put(keyVal[0], keyVal[1]);
                    continue block18;
                }
            }
            if (this.url == null) {
                this.url = option;
                continue;
            }
            throw new IllegalArgumentException("Invalid option: " + option);
        }
        if (this.url == null) {
            throw new IllegalArgumentException("Resource URI not specified");
        }
        if (this.outputResult && this.returnId) {
            throw new IllegalArgumentException("Options -o and -i are mutually exclusive");
        }
        try {
            this.outputFormat = OutputFormat.valueOf(this.format.toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported output format: " + this.format);
        }
        if (this.mergeMode && this.noMerge) {
            throw new IllegalArgumentException("Options --merge and --no-merge are mutually exclusive");
        }
        if (this.body != null && this.file != null) {
            throw new IllegalArgumentException("Options --body and --file are mutually exclusive");
        }
        if (this.file == null && this.attrs.size() > 0 && !this.noMerge) {
            this.mergeMode = true;
        }
    }

    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        int lastByte;
        AccessibleBufferOutputStream abos;
        block46: {
            Header location;
            String id;
            HeadersBodyStatus response;
            Header ctype = this.headers.get("content-type");
            InputStream content = null;
            CmdStdinContext<Object> ctx = new CmdStdinContext();
            if (this.file != null) {
                if (ctype != null && !"application/json".equals(ctype.getValue())) {
                    if ("-".equals(this.file)) {
                        content = System.in;
                    } else {
                        try {
                            content = new BufferedInputStream(new FileInputStream(this.file));
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException("File not found: " + this.file);
                        }
                    }
                } else {
                    ctx = ParseUtil.parseFileOrStdin(this.file);
                }
            } else if (this.body != null) {
                content = new ByteArrayInputStream(this.body.getBytes(StandardCharsets.UTF_8));
            }
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            this.setupTruststore(config, commandInvocation);
            String auth = null;
            config = this.ensureAuthInfo(config, commandInvocation);
            config = this.copyWithServerInfo(config);
            if (ConfigUtil.credentialsAvailable(config)) {
                auth = AuthUtil.ensureToken(config);
            }
            String string = auth = auth != null ? "Bearer " + auth : null;
            if (auth != null) {
                this.headers.addIfMissing("Authorization", auth);
            }
            String server = config.getServerUrl();
            String realm = this.getTargetRealm(config);
            String adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
            String resourceUrl = HttpUtil.composeResourceUrl(adminRoot, realm, this.url);
            String typeName = this.extractTypeNameFromUri(resourceUrl);
            if (this.filter.size() > 0) {
                resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, this.filter);
            }
            this.headers.addIfMissing("Accept", "application/json");
            if (this.isUpdate() && this.mergeMode) {
                ObjectNode result;
                try {
                    HeadersBodyStatus response2 = HttpUtil.doGet(resourceUrl, new HeadersBody(this.headers));
                    HttpUtil.checkSuccess(resourceUrl, response2);
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    IoUtil.copyStream(response2.getBody(), buffer);
                    result = OutputUtil.MAPPER.readValue(buffer.toByteArray(), ObjectNode.class);
                }
                catch (IOException e) {
                    throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
                }
                CmdStdinContext<ObjectNode> ctxremote = new CmdStdinContext<ObjectNode>();
                ctxremote.setResult(result);
                if (ctx.getResult() != null) {
                    ReflectionUtil.merge((JsonNode)ctx.getResult(), (ObjectNode)ctxremote.getResult());
                }
                ctx = ctxremote;
            }
            if (this.attrs.size() > 0) {
                if (content != null) {
                    throw new RuntimeException("Can't set attributes on content of type other than application/json");
                }
                ctx = ParseUtil.mergeAttributes(ctx, OutputUtil.MAPPER.createObjectNode(), this.attrs);
            }
            if (content == null && ctx.getContent() != null) {
                content = new ByteArrayInputStream(ctx.getContent().getBytes(StandardCharsets.UTF_8));
            }
            ReturnFields returnFields = null;
            if (this.fields != null) {
                returnFields = new ReturnFields(this.fields);
            }
            if (content != null) {
                this.headers.addIfMissing("Content-Type", "application/json");
            }
            LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
            if (this.offset != null) {
                queryParams.put("first", String.valueOf(this.offset));
            }
            if (this.limit != null) {
                queryParams.put("max", String.valueOf(this.limit));
            }
            if (queryParams.size() > 0) {
                resourceUrl = HttpUtil.addQueryParamsToUri(resourceUrl, queryParams);
            }
            try {
                response = HttpUtil.doRequest(this.httpVerb, resourceUrl, new HeadersBody(this.headers, content));
            }
            catch (IOException e) {
                throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
            }
            if (this.printHeaders) {
                IoUtil.printOut(response.getStatus());
                for (Header header : response.getHeaders()) {
                    IoUtil.printOut(header.getName() + ": " + header.getValue());
                }
            }
            HttpUtil.checkSuccess(resourceUrl, response);
            abos = new AccessibleBufferOutputStream(System.out);
            if (response.getBody() == null) {
                throw new RuntimeException("Internal error - response body should never be null");
            }
            if (this.printHeaders) {
                IoUtil.printOut("");
            }
            String string2 = id = (location = response.getHeaders().get("Location")) != null ? this.extractLastComponentOfUri(location.getValue()) : null;
            if (id != null) {
                if (this.returnId) {
                    IoUtil.printOut(id);
                } else if (!this.outputResult) {
                    IoUtil.printErr("Created new " + typeName + " with id '" + id + "'");
                }
            }
            if (this.outputResult) {
                boolean pretty;
                Header contentType;
                if (this.isCreateOrUpdate() && (response.getStatusCode() == 204 || id != null)) {
                    this.headers = new Headers();
                    if (auth != null) {
                        this.headers.add("Authorization", auth);
                    }
                    try {
                        String fetchUrl = id != null ? resourceUrl + "/" + id : resourceUrl;
                        response = HttpUtil.doGet(fetchUrl, new HeadersBody(this.headers));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("HTTP request error: " + e.getMessage(), e);
                    }
                }
                boolean canPrettyPrint = (contentType = response.getHeaders().get("content-type")) != null && contentType.getValue().equals("application/json");
                boolean bl = pretty = !this.compressed;
                if (canPrettyPrint && (pretty || returnFields != null)) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    IoUtil.copyStream(response.getBody(), buffer);
                    try {
                        JsonNode rootNode = OutputUtil.MAPPER.readValue(buffer.toByteArray(), JsonNode.class);
                        if (returnFields != null) {
                            rootNode = this.applyFieldFilter(OutputUtil.MAPPER, rootNode, returnFields);
                        }
                        if (this.outputFormat == OutputFormat.JSON) {
                            OutputUtil.MAPPER.writeValue(abos, (Object)rootNode);
                            break block46;
                        }
                        OutputUtil.printAsCsv(rootNode, returnFields, this.unquoted);
                    }
                    catch (Exception ignored) {
                        IoUtil.copyStream(new ByteArrayInputStream(buffer.toByteArray()), abos);
                    }
                } else {
                    IoUtil.copyStream(response.getBody(), abos);
                }
            }
        }
        if ((lastByte = abos.getLastByte()) != -1 && lastByte != 13 && lastByte != 10) {
            IoUtil.printErr("");
        }
        return CommandResult.SUCCESS;
    }

    private boolean isUpdate() {
        return "put".equals(this.httpVerb);
    }

    private boolean isCreateOrUpdate() {
        return "post".equals(this.httpVerb) || "put".equals(this.httpVerb);
    }
}

