/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rotation;

import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.rotation.KeyLocator;

public class HardcodedKeyLocator
implements KeyLocator,
Iterable<Key> {
    private final Map<String, ? extends Key> byName;
    private final Map<KeyLocator.KeyHash, ? extends Key> byKey;

    public HardcodedKeyLocator(Key key) {
        Objects.requireNonNull(key, "Key must not be null");
        this.byName = Collections.emptyMap();
        this.byKey = Collections.singletonMap(new KeyLocator.KeyHash(key), key);
    }

    public HardcodedKeyLocator(Collection<? extends Key> keys) {
        Objects.requireNonNull(keys, "Keys must not be null");
        this.byName = Collections.emptyMap();
        this.byKey = Collections.unmodifiableMap(keys.stream().collect(Collectors.toMap(k -> new KeyLocator.KeyHash((Key)k), k -> k)));
    }

    public HardcodedKeyLocator(Map<String, ? extends Key> keys) {
        Objects.requireNonNull(keys, "Keys must not be null");
        this.byName = Collections.unmodifiableMap(keys);
        this.byKey = Collections.unmodifiableMap(keys.values().stream().collect(Collectors.toMap(k -> new KeyLocator.KeyHash((Key)k), k -> k)));
    }

    @Override
    public Key getKey(String kid) {
        if (this.byKey.size() == 1) {
            return this.byKey.values().iterator().next();
        }
        if (kid == null) {
            return null;
        }
        return this.byName.get(kid);
    }

    @Override
    public Key getKey(Key key) {
        if (this.byKey.size() == 1) {
            return this.byKey.values().iterator().next();
        }
        if (key == null) {
            return null;
        }
        return this.byKey.get(new KeyLocator.KeyHash(key));
    }

    @Override
    public void refreshKeyCache() {
    }

    public String toString() {
        return "hardcoded keys, count: " + this.byKey.size();
    }

    @Override
    public Iterator<Key> iterator() {
        return this.byKey.values().iterator();
    }
}

