/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import jakarta.transaction.Transaction;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class XaTransactionTable
extends TransactionTable {
    private static final Log log = LogFactory.getLog(XaTransactionTable.class);
    @Inject
    protected RecoveryManager recoveryManager;
    @ComponentName(value="cacheName")
    @Inject
    protected String cacheName;
    protected ConcurrentMap<XidImpl, LocalXaTransaction> xid2LocalTx;

    @Start(priority=9)
    public void startXidMapping() {
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.xid2LocalTx = new ConcurrentHashMap<XidImpl, LocalXaTransaction>(concurrencyLevel, 0.75f, concurrencyLevel);
    }

    @Override
    public boolean removeLocalTransaction(LocalTransaction localTx) {
        boolean result = false;
        if (localTx.getTransaction() != null) {
            result = super.removeLocalTransaction(localTx);
        }
        this.removeXidTxMapping((LocalXaTransaction)localTx);
        return result;
    }

    private void removeXidTxMapping(LocalXaTransaction localTx) {
        XidImpl xid = localTx.getXid();
        if (xid != null) {
            this.xid2LocalTx.remove(xid);
        }
    }

    public LocalXaTransaction getLocalTransaction(XidImpl xid) {
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.xid2LocalTx.get(xid);
        if (localTransaction == null && log.isTraceEnabled()) {
            log.tracef("no tx found for %s", xid);
        }
        return localTransaction;
    }

    private void addLocalTransactionMapping(LocalXaTransaction localTransaction) {
        if (localTransaction.getXid() == null) {
            throw new IllegalStateException("Initialize xid first!");
        }
        this.xid2LocalTx.put(localTransaction.getXid(), localTransaction);
    }

    @Override
    public void enlist(Transaction transaction, LocalTransaction ltx) {
        LocalXaTransaction localTransaction = (LocalXaTransaction)ltx;
        if (!localTransaction.isEnlisted()) {
            try {
                transaction.enlistResource((XAResource)new TransactionXaAdapter(localTransaction, this));
            }
            catch (Exception e) {
                XidImpl xid = localTransaction.getXid();
                if (xid != null && !localTransaction.getLookedUpEntries().isEmpty()) {
                    log.debug("Attempting a rollback to clear stale resources asynchronously!");
                    this.txCoordinator.rollback(localTransaction).exceptionally(t -> {
                        log.warn("Caught exception attempting to clean up " + xid + " for " + localTransaction.getGlobalTransaction(), (Throwable)t);
                        return null;
                    });
                }
                log.failedToEnlistTransactionXaAdapter(e);
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public void enlistClientTransaction(Transaction transaction, LocalTransaction localTransaction) {
        this.enlist(transaction, localTransaction);
    }

    @Override
    public int getLocalTxCount() {
        return this.xid2LocalTx.size();
    }

    public CompletionStage<Integer> prepare(XidImpl xid) {
        LocalXaTransaction localTransaction = this.getLocalTransaction(xid);
        if (localTransaction == null) {
            return CompletableFutures.completedExceptionFuture((Throwable)new XAException(-4));
        }
        return this.txCoordinator.prepare(localTransaction);
    }

    public CompletionStage<Void> commit(XidImpl xid, boolean isOnePhase) {
        CompletionStage<Integer> prepareStage;
        LocalXaTransaction localTransaction = this.getLocalTransaction(xid);
        if (localTransaction == null) {
            return CompletableFutures.completedExceptionFuture((Throwable)new XAException(-4));
        }
        CompletionStage<Boolean> commitStage = isOnePhase && !CompletionStages.isCompletedSuccessfully(prepareStage = this.txCoordinator.prepare(localTransaction)) ? prepareStage.thenCompose(ignore -> this.txCoordinator.commit(localTransaction, false)) : this.txCoordinator.commit(localTransaction, false);
        if (CompletionStages.isCompletedSuccessfully(commitStage)) {
            boolean committedInOnePhase2 = CompletionStages.join(commitStage);
            this.forgetSuccessfullyCompletedTransaction(localTransaction, committedInOnePhase2);
            return CompletableFutures.completedNull();
        }
        return commitStage.thenApply(committedInOnePhase -> {
            this.forgetSuccessfullyCompletedTransaction(localTransaction, (boolean)committedInOnePhase);
            return null;
        });
    }

    CompletionStage<Void> rollback(XidImpl xid) {
        LocalXaTransaction localTransaction = this.getLocalTransaction(xid);
        if (localTransaction == null) {
            return CompletableFutures.completedExceptionFuture((Throwable)new XAException(-4));
        }
        localTransaction.markForRollback(true);
        return this.txCoordinator.rollback(localTransaction);
    }

    void start(XidImpl xid, LocalXaTransaction localTransaction) {
        localTransaction.setXid(xid);
        this.addLocalTransactionMapping(localTransaction);
        if (log.isTraceEnabled()) {
            log.tracef("start called on tx %s", localTransaction.getGlobalTransaction());
        }
    }

    void end(LocalXaTransaction localTransaction) {
        if (log.isTraceEnabled()) {
            log.tracef("end called on tx %s(%s)", localTransaction.getGlobalTransaction(), this.cacheName);
        }
    }

    CompletionStage<Void> forget(XidImpl xid) {
        if (log.isTraceEnabled()) {
            log.tracef("forget called for xid %s", xid);
        }
        if (this.isRecoveryEnabled()) {
            return this.recoveryManager.removeRecoveryInformation(null, xid, null, false).exceptionally(t -> {
                log.warnExceptionRemovingRecovery((Throwable)t);
                XAException xe = new XAException(-3);
                xe.initCause((Throwable)t);
                throw new CompletionException(xe);
            });
        }
        if (log.isTraceEnabled()) {
            log.trace("Recovery not enabled");
        }
        return CompletableFutures.completedNull();
    }

    boolean isRecoveryEnabled() {
        return this.recoveryManager != null;
    }

    private void forgetSuccessfullyCompletedTransaction(LocalXaTransaction localTransaction, boolean committedInOnePhase) {
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        XidImpl xid = localTransaction.getXid();
        if (this.isRecoveryEnabled()) {
            this.recoveryManager.removeRecoveryInformation(localTransaction.getRemoteLocksAcquired(), xid, gtx, this.partitionHandlingManager.isTransactionPartiallyCommitted(gtx));
            this.removeLocalTransaction(localTransaction);
        } else {
            this.releaseLocksForCompletedTransaction(localTransaction, committedInOnePhase);
        }
    }
}

