/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.locking;

import org.infinispan.client.hotrod.RemoteCache;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.locking.GlobalLockProviderFactory;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.locking.HotRodGlobalLockProvider;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class HotRodGlobalLockProviderFactory
implements GlobalLockProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "hotrod";
    protected static final String HOT_ROD_LOCKS_CACHE = "locks";
    private RemoteCache<String, String> locksCache;
    private long defaultTimeoutMilliseconds;

    public GlobalLockProvider create(KeycloakSession session) {
        if (this.locksCache == null) {
            this.lazyInit(session);
        }
        return new HotRodGlobalLockProvider(session, this.locksCache, this.defaultTimeoutMilliseconds);
    }

    private void lazyInit(KeycloakSession session) {
        HotRodConnectionProvider hotRodConnectionProvider = (HotRodConnectionProvider)session.getProvider(HotRodConnectionProvider.class);
        this.locksCache = hotRodConnectionProvider.getRemoteCache(HOT_ROD_LOCKS_CACHE);
    }

    public void init(Config.Scope config) {
        this.defaultTimeoutMilliseconds = config.getLong("defaultTimeoutMilliseconds", Long.valueOf(5000L));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

