/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;

public class JivePropertiesExtensionProvider
extends ExtensionElementProvider<JivePropertiesExtension> {
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtensionProvider.class.getName());

    @Override
    public JivePropertiesExtension parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        block2: while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT && parser2.getName().equals("property")) {
                boolean done = false;
                String name = null;
                String type2 = null;
                String valueText = null;
                Object value2 = null;
                while (true) {
                    if (done) continue block2;
                    eventType = parser2.next();
                    if (eventType == XmlPullParser.Event.START_ELEMENT) {
                        String elementName = parser2.getName();
                        if (elementName.equals("name")) {
                            name = parser2.nextText();
                            continue;
                        }
                        if (!elementName.equals("value")) continue;
                        type2 = parser2.getAttributeValue("", "type");
                        valueText = parser2.nextText();
                        continue;
                    }
                    if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("property")) continue;
                    if ("integer".equals(type2)) {
                        value2 = Integer.valueOf(valueText);
                    } else if ("long".equals(type2)) {
                        value2 = Long.valueOf(valueText);
                    } else if ("float".equals(type2)) {
                        value2 = Float.valueOf(valueText);
                    } else if ("double".equals(type2)) {
                        value2 = Double.valueOf(valueText);
                    } else if ("boolean".equals(type2)) {
                        value2 = Boolean.valueOf(valueText);
                    } else if ("string".equals(type2)) {
                        value2 = valueText;
                    } else if ("java-object".equals(type2)) {
                        if (JivePropertiesManager.isJavaObjectEnabled()) {
                            try {
                                byte[] bytes = Base64.decode(valueText);
                                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                                value2 = in.readObject();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Error parsing java object", e);
                            }
                        } else {
                            LOGGER.severe("JavaObject is not enabled. Enable with JivePropertiesManager.setJavaObjectEnabled(true)");
                        }
                    }
                    if (name != null && value2 != null) {
                        properties2.put(name, value2);
                    }
                    done = true;
                }
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getName().equals("properties")) break;
        }
        return new JivePropertiesExtension(properties2);
    }
}

