/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.websocket.ColibriWebSocketServlet;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService;", "", "webserverIsTls", "", "(Z)V", "baseUrls", "", "", "relayBaseUrls", "getColibriRelayWebSocketUrls", "conferenceId", "relayId", "pwd", "getColibriWebSocketUrls", "endpointId", "registerServlet", "", "servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "Companion", "jitsi-videobridge"})
public final class ColibriWebSocketService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> baseUrls;
    @NotNull
    private final List<String> relayBaseUrls;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null);
    @NotNull
    private static final String COLIBRI_WS_ENDPOINT = "colibri-ws";
    @NotNull
    private static final String COLIBRI_RELAY_WS_ENDPOINT = "colibri-relay-ws";
    @NotNull
    public static final String COLIBRI_WS_PATH = "/colibri-ws/";
    @NotNull
    public static final String COLIBRI_RELAY_WS_PATH = "/colibri-relay-ws/";

    public ColibriWebSocketService(boolean webserverIsTls) {
        if (WebsocketServiceConfig.config.getEnabled()) {
            List<String> list;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Boolean bl = WebsocketServiceConfig.config.getUseTls();
            boolean useTls2 = bl != null ? bl : webserverIsTls;
            String protocol = useTls2 ? "wss" : "ws";
            Iterable iterable = WebsocketServiceConfig.config.getDomains();
            ColibriWebSocketService colibriWebSocketService = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(protocol + "://" + it + COLIBRI_WS_PATH + WebsocketServiceConfig.config.getServerId());
            }
            colibriWebSocketService.baseUrls = (List)destination$iv$iv;
            ColibriWebSocketService colibriWebSocketService2 = this;
            if (RelayConfig.config.getEnabled()) {
                $this$map$iv = WebsocketServiceConfig.config.getRelayDomains();
                colibriWebSocketService = colibriWebSocketService2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(protocol + "://" + it + COLIBRI_RELAY_WS_PATH + WebsocketServiceConfig.config.getServerId());
                }
                list = (List)destination$iv$iv;
                colibriWebSocketService2 = colibriWebSocketService;
            } else {
                list = colibriWebSocketService2.relayBaseUrls = CollectionsKt.emptyList();
            }
            if (this.baseUrls.isEmpty() || this.relayBaseUrls.isEmpty()) {
                logger.warn("Websockets enabled, but no domains specified: URLs=" + this.baseUrls + ", Relay URLs=" + this.relayBaseUrls);
            } else {
                logger.info("Base URL: " + this.baseUrls + " Relay URL: " + this.relayBaseUrls);
            }
        } else {
            logger.info("WebSockets are not enabled");
            this.baseUrls = CollectionsKt.emptyList();
            this.relayBaseUrls = CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getColibriWebSocketUrls(@NotNull String conferenceId, @NotNull String endpointId, @NotNull String pwd) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter(pwd, "pwd");
        Iterable $this$map$iv = this.baseUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "/" + conferenceId + "/" + endpointId + "?pwd=" + pwd);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getColibriRelayWebSocketUrls(@NotNull String conferenceId, @NotNull String relayId, @NotNull String pwd) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        Intrinsics.checkNotNullParameter(pwd, "pwd");
        Iterable $this$map$iv = this.relayBaseUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "/" + conferenceId + "/" + relayId + "?pwd=" + pwd);
        }
        return (List)destination$iv$iv;
    }

    public final void registerServlet(@NotNull ServletContextHandler servletContextHandler, @NotNull Videobridge videobridge) {
        Intrinsics.checkNotNullParameter(servletContextHandler, "servletContextHandler");
        Intrinsics.checkNotNullParameter(videobridge, "videobridge");
        if (WebsocketServiceConfig.config.getEnabled()) {
            ServletHolder servletHolder;
            logger.info("Registering servlet with baseUrls = " + this.baseUrls + ", relayBaseUrls = " + this.relayBaseUrls);
            ServletHolder $this$registerServlet_u24lambda_u2d4 = servletHolder = new ServletHolder();
            boolean bl = false;
            $this$registerServlet_u24lambda_u2d4.setServlet(new ColibriWebSocketServlet(WebsocketServiceConfig.config.getServerId(), videobridge));
            ServletHolder holder = servletHolder;
            servletContextHandler.addServlet(holder, "/colibri-ws/*");
            servletContextHandler.addServlet(holder, "/colibri-relay-ws/*");
            JettyWebSocketServletContainerInitializer.configure(servletContextHandler, null);
        } else {
            logger.info("Disabled, not registering servlet");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/websocket/ColibriWebSocketService$Companion;", "", "()V", "COLIBRI_RELAY_WS_ENDPOINT", "", "COLIBRI_RELAY_WS_PATH", "COLIBRI_WS_ENDPOINT", "COLIBRI_WS_PATH", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

