/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.stats.RateTracker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0012\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011H\u0017J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/util/BitrateTracker;", "", "windowSize", "Ljava/time/Duration;", "bucketSize", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Clock;)V", "rate", "Lorg/jitsi/nlj/util/Bandwidth;", "getRate-rlWvAKk", "()D", "tracker", "Lorg/jitsi/utils/stats/RateTracker;", "getAccumulatedSize", "Lorg/jitsi/nlj/util/DataSize;", "now", "", "getRate", "nowMs", "getRate-WElJv5I", "(J)D", "getRateBps", "update", "", "dataSize", "jitsi-media-transform"})
public class BitrateTracker {
    @NotNull
    private final Duration windowSize;
    @NotNull
    private final Duration bucketSize;
    @NotNull
    private final Clock clock;
    @NotNull
    private final RateTracker tracker;

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        Intrinsics.checkNotNullParameter(bucketSize, "bucketSize");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.windowSize = windowSize;
        this.bucketSize = bucketSize;
        this.clock = clock;
        this.tracker = new RateTracker(this.windowSize, this.bucketSize, this.clock);
    }

    public /* synthetic */ BitrateTracker(Duration duration, Duration duration2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            duration2 = DurationKt.getMs(1);
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(duration, duration2, clock);
    }

    public double getRate-WElJv5I(long nowMs) {
        return BandwidthKt.getBps(this.tracker.getRate(nowMs));
    }

    public static /* synthetic */ double getRate-WElJv5I$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRate-WElJv5I");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getRate-WElJv5I(l);
    }

    @JvmOverloads
    public long getRateBps(long nowMs) {
        return this.tracker.getRate(nowMs);
    }

    public static /* synthetic */ long getRateBps$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRateBps");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getRateBps(l);
    }

    public final double getRate-rlWvAKk() {
        return BitrateTracker.getRate-WElJv5I$default(this, 0L, 1, null);
    }

    public final void update(@NotNull DataSize dataSize, long now) {
        Intrinsics.checkNotNullParameter(dataSize, "dataSize");
        this.tracker.update(dataSize.getBits(), now);
    }

    public static /* synthetic */ void update$default(BitrateTracker bitrateTracker, DataSize dataSize, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            l = bitrateTracker.clock.millis();
        }
        bitrateTracker.update(dataSize, l);
    }

    @NotNull
    public final DataSize getAccumulatedSize(long now) {
        return DataSizeKt.getBits(this.tracker.getAccumulatedCount(now));
    }

    public static /* synthetic */ DataSize getAccumulatedSize$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAccumulatedSize");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getAccumulatedSize(l);
    }

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        Intrinsics.checkNotNullParameter(bucketSize, "bucketSize");
        this(windowSize, bucketSize, null, 4, null);
    }

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        this(windowSize, null, null, 6, null);
    }

    @JvmOverloads
    public final long getRateBps() {
        return BitrateTracker.getRateBps$default(this, 0L, 1, null);
    }
}

