/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import sun.misc.Unsafe;

public class InetSocketAddress
extends SocketAddress {
    private final transient InetSocketAddressHolder holder;
    private static final long serialVersionUID = 5076001401234631237L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostname", String.class), new ObjectStreamField("addr", InetAddress.class), new ObjectStreamField("port", Integer.TYPE)};
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;

    private static int checkPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out of range:" + n);
        }
        return n;
    }

    private static String checkHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        return string;
    }

    public InetSocketAddress(int n) {
        this(InetAddress.anyLocalAddress(), n);
    }

    public InetSocketAddress(InetAddress inetAddress, int n) {
        this.holder = new InetSocketAddressHolder(null, inetAddress == null ? InetAddress.anyLocalAddress() : inetAddress, InetSocketAddress.checkPort(n));
    }

    public InetSocketAddress(String string, int n) {
        InetSocketAddress.checkHost(string);
        InetAddress inetAddress = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        this.holder = new InetSocketAddressHolder(string2, inetAddress, InetSocketAddress.checkPort(n));
    }

    private InetSocketAddress(int n, String string) {
        this.holder = new InetSocketAddressHolder(string, null, n);
    }

    public static InetSocketAddress createUnresolved(String string, int n) {
        return new InetSocketAddress(InetSocketAddress.checkPort(n), InetSocketAddress.checkHost(string));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hostname", this.holder.hostname);
        putField.put("addr", this.holder.addr);
        putField.put("port", this.holder.port);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("hostname", null);
        InetAddress inetAddress = (InetAddress)getField.get("addr", null);
        int n = getField.get("port", -1);
        InetSocketAddress.checkPort(n);
        if (string == null && inetAddress == null) {
            throw new InvalidObjectException("hostname and addr can't both be null");
        }
        InetSocketAddressHolder inetSocketAddressHolder = new InetSocketAddressHolder(string, inetAddress, n);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inetSocketAddressHolder);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    public final int getPort() {
        return this.holder.getPort();
    }

    public final InetAddress getAddress() {
        return this.holder.getAddress();
    }

    public final String getHostName() {
        return this.holder.getHostName();
    }

    public final String getHostString() {
        return this.holder.getHostString();
    }

    public final boolean isUnresolved() {
        return this.holder.isUnresolved();
    }

    public String toString() {
        return this.holder.toString();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof InetSocketAddress)) {
            return false;
        }
        return this.holder.equals(((InetSocketAddress)object).holder);
    }

    public final int hashCode() {
        return this.holder.hashCode();
    }

    static {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(InetSocketAddress.class.getDeclaredField("holder"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    private static class InetSocketAddressHolder {
        private String hostname;
        private InetAddress addr;
        private int port;

        private InetSocketAddressHolder(String string, InetAddress inetAddress, int n) {
            this.hostname = string;
            this.addr = inetAddress;
            this.port = n;
        }

        private int getPort() {
            return this.port;
        }

        private InetAddress getAddress() {
            return this.addr;
        }

        private String getHostName() {
            if (this.hostname != null) {
                return this.hostname;
            }
            if (this.addr != null) {
                return this.addr.getHostName();
            }
            return null;
        }

        private String getHostString() {
            if (this.hostname != null) {
                return this.hostname;
            }
            if (this.addr != null) {
                if (this.addr.holder().getHostName() != null) {
                    return this.addr.holder().getHostName();
                }
                return this.addr.getHostAddress();
            }
            return null;
        }

        private boolean isUnresolved() {
            return this.addr == null;
        }

        public String toString() {
            if (this.isUnresolved()) {
                return this.hostname + ":" + this.port;
            }
            return this.addr.toString() + ":" + this.port;
        }

        public final boolean equals(Object object) {
            if (object == null || !(object instanceof InetSocketAddressHolder)) {
                return false;
            }
            InetSocketAddressHolder inetSocketAddressHolder = (InetSocketAddressHolder)object;
            boolean bl = this.addr != null ? this.addr.equals(inetSocketAddressHolder.addr) : (this.hostname != null ? inetSocketAddressHolder.addr == null && this.hostname.equalsIgnoreCase(inetSocketAddressHolder.hostname) : inetSocketAddressHolder.addr == null && inetSocketAddressHolder.hostname == null);
            return bl && this.port == inetSocketAddressHolder.port;
        }

        public final int hashCode() {
            if (this.addr != null) {
                return this.addr.hashCode() + this.port;
            }
            if (this.hostname != null) {
                return this.hostname.toLowerCase().hashCode() + this.port;
            }
            return this.port;
        }
    }
}

