/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverDirectHTTP;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverFragment;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverLocalFilesystem;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;

public class ResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);
    private static final List<ResourceResolver> resolverList = new ArrayList<ResourceResolver>();
    private final ResourceResolverSpi resolverSpi;

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string, boolean bl) throws ResourceResolverException {
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        return ResourceResolver.internalGetInstance(resourceResolverContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <N> ResourceResolver internalGetInstance(ResourceResolverContext resourceResolverContext) throws ResourceResolverException {
        Object[] objectArray = resolverList;
        synchronized (resolverList) {
            Iterator<ResourceResolver> iterator = resolverList.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray2;
                ResourceResolver resourceResolver;
                ResourceResolver resourceResolver2 = resourceResolver = iterator.next();
                if (!resourceResolver.resolverSpi.engineIsThreadSafe()) {
                    try {
                        objectArray2 = new ResourceResolver((ResourceResolverSpi)resourceResolver.resolverSpi.getClass().newInstance());
                        resourceResolver2 = objectArray2;
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ResourceResolverException(instantiationException, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri, "");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ResourceResolverException(illegalAccessException, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri, "");
                    }
                }
                LOG.debug("check resolvability by class {}", resourceResolver2.getClass().getName());
                if (!resourceResolver2.canResolve(resourceResolverContext)) continue;
                if (resourceResolverContext.secureValidation && (resourceResolver2.resolverSpi instanceof ResolverLocalFilesystem || resourceResolver2.resolverSpi instanceof ResolverDirectHTTP)) {
                    objectArray2 = new Object[]{resourceResolver2.resolverSpi.getClass().getName()};
                    throw new ResourceResolverException("signature.Reference.ForbiddenResolver", objectArray2, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return resourceResolver2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            objectArray = new Object[]{resourceResolverContext.uriToResolve != null ? resourceResolverContext.uriToResolve : "null", resourceResolverContext.baseUri};
            throw new ResourceResolverException("utils.resolver.noClass", objectArray, resourceResolverContext.uriToResolve, resourceResolverContext.baseUri);
        }
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list) throws ResourceResolverException {
        return ResourceResolver.getInstance(attr, string, list, true);
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list, boolean bl) throws ResourceResolverException {
        LOG.debug("I was asked to create a ResourceResolver and got {}", list == null ? 0 : list.size());
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ResourceResolver resourceResolver = list.get(i);
                if (resourceResolver == null) continue;
                String string2 = resourceResolver.resolverSpi.getClass().getName();
                LOG.debug("check resolvability by class {}", string2);
                if (!resourceResolver.canResolve(resourceResolverContext)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.internalGetInstance(resourceResolverContext);
    }

    public static void register(String string) {
        JavaUtils.checkRegisterPermission();
        try {
            Class<?> clazz = ClassLoaderUtils.loadClass(string, ResourceResolver.class);
            ResourceResolver.register(clazz, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.warn("Error loading resolver " + string + " disabling it");
        }
    }

    public static void registerAtStart(String string) {
        JavaUtils.checkRegisterPermission();
        try {
            Class<?> clazz = ClassLoaderUtils.loadClass(string, ResourceResolver.class);
            ResourceResolver.register(clazz, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.warn("Error loading resolver " + string + " disabling it");
        }
    }

    public static void register(Class<? extends ResourceResolverSpi> clazz, boolean bl) {
        JavaUtils.checkRegisterPermission();
        try {
            ResourceResolverSpi resourceResolverSpi = clazz.newInstance();
            ResourceResolver.register(resourceResolverSpi, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.warn("Error loading resolver " + clazz + " disabling it");
        }
        catch (InstantiationException instantiationException) {
            LOG.warn("Error loading resolver " + clazz + " disabling it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResourceResolverSpi resourceResolverSpi, boolean bl) {
        JavaUtils.checkRegisterPermission();
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            if (bl) {
                resolverList.add(0, new ResourceResolver(resourceResolverSpi));
            } else {
                resolverList.add(new ResourceResolver(resourceResolverSpi));
            }
        }
        LOG.debug("Registered resolver: {}", resourceResolverSpi.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDefaultResolvers() {
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            resolverList.add(new ResourceResolver(new ResolverFragment()));
            resolverList.add(new ResourceResolver(new ResolverLocalFilesystem()));
            resolverList.add(new ResourceResolver(new ResolverXPointer()));
            resolverList.add(new ResourceResolver(new ResolverDirectHTTP()));
        }
    }

    public XMLSignatureInput resolve(Attr attr, String string, boolean bl) throws ResourceResolverException {
        ResourceResolverContext resourceResolverContext = new ResourceResolverContext(attr, string, bl);
        return this.resolverSpi.engineResolveURI(resourceResolverContext);
    }

    public void setProperty(String string, String string2) {
        this.resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map<String, String> map) {
        this.resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this.resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this.resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(ResourceResolverContext resourceResolverContext) {
        return this.resolverSpi.engineCanResolveURI(resourceResolverContext);
    }
}

